/**
 * WildCAT
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 EMN
 * Contact: wildcat@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: QueryListener.java 330 2008-09-03 17:03:41Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.wildcat.osgi;

import java.util.HashMap;
import java.util.Map;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.ow2.wildcat.Context;
import org.ow2.wildcat.Query;
import org.ow2.wildcat.hierarchy.ListenerRegistrationException;
import org.ow2.wildcat.osgi.api.IQueryAdder;

/**
 * Listen for adding and removing of queries.
 * @author Loris Bouzonnet
 */
public class QueryListener implements ServiceListener {

    /**
     * OSGi bundle context to retrieve the incoming {@link IQueryAdder}.
     */
    private final BundleContext context;

    /**
     * WildCAT Context.
     */
    private final Context ctx;

    /**
     * Queries.
     */
    private final Map<ServiceReference, Query> queries = new HashMap<ServiceReference, Query>();

    /**
     * @param bundleContext
     * @param ctx
     */
    public QueryListener(BundleContext bundleContext, Context ctx) {
        this.context = bundleContext;
        this.ctx = ctx;
    }

    /**
     * @param event
     */
    public void serviceChanged(ServiceEvent event) {
        ServiceReference ref = event.getServiceReference();
        // React on REGISTERED|UNREGISTERING events
        switch(event.getType()) {
            case ServiceEvent.REGISTERED:
                IQueryAdder queryAdder = (IQueryAdder) context.getService(ref);
                try {
                    queries.put(ref, queryAdder.registerListener(ctx));
                } catch (ListenerRegistrationException e) {
                    e.printStackTrace();
                }
                break;
            case ServiceEvent.UNREGISTERING:
                ctx.destroyQuery(queries.remove(ref));
                break;
        }
    }

}
