/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.hierarchy.attribute;

import java.io.Serializable;
import net.esper.client.UpdateListener;
import net.esper.event.EventBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.wildcat.Context;
import org.ow2.wildcat.Query;
import org.ow2.wildcat.event.WAttributeEvent;
import org.ow2.wildcat.hierarchy.Mountable;
import org.ow2.wildcat.hierarchy.Path;
import org.ow2.wildcat.hierarchy.attribute.Attribute;
import org.ow2.wildcat.util.Messages;

public class QueryAttribute
implements Attribute,
UpdateListener,
Serializable {
    private static final long serialVersionUID = 5484145491004179031L;
    private static Log logger = LogFactory.getLog(QueryAttribute.class);
    private final String queryString;
    private Query query;
    private Object value;
    private Context context;
    private Path path;

    public QueryAttribute(String queryString) {
        this.queryString = queryString;
    }

    public Object getValue() {
        return this.value;
    }

    public Object setValue(Object value) {
        return this.value;
    }

    public boolean isMount() {
        return this.context != null && this.path != null;
    }

    public void mount(Context context, Path mountPoint) {
        logger.debug((Object)Messages.message(Mountable.class.getName() + ".mount", mountPoint));
        if (this.isMount()) {
            logger.info((Object)Messages.message(Mountable.class.getName() + ".alreadymount", mountPoint));
        } else {
            this.context = context;
            this.path = mountPoint;
            this.query = this.context.registerListeners(this.queryString, this);
        }
    }

    public void unMount() {
        logger.debug((Object)Messages.message(Mountable.class.getName() + ".unmount", null));
        if (this.isMount() && this.query != null) {
            this.context.destroyQuery(this.query);
        }
        this.query = null;
        this.context = null;
        this.path = null;
    }

    public void update(EventBean[] arg0, EventBean[] arg1) {
        if (arg0 == null || arg0.length == 0) {
            this.value = null;
        } else if (arg0.length == 1) {
            this.value = arg0[0].getUnderlying();
        } else {
            Object[] oa = new Object[arg0.length];
            for (int i = 0; i < arg0.length; ++i) {
                oa[i] = arg0[i].getUnderlying();
            }
            this.value = oa;
        }
        if (this.isMount()) {
            this.context.emitEvent(new WAttributeEvent(this.path, this.value));
        }
    }
}

