/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.osgi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.wildcat.Context;
import org.ow2.wildcat.ContextException;
import org.ow2.wildcat.ContextFactory;
import org.ow2.wildcat.osgi.AttributeListener;
import org.ow2.wildcat.osgi.QueryListener;
import org.ow2.wildcat.osgi.api.IAttributeAttacher;
import org.ow2.wildcat.osgi.api.IQueryAdder;

public class Activator
implements BundleActivator,
NotificationListener {
    private static Log logger = LogFactory.getLog(Activator.class);
    private Context ctx;
    private ServiceRegistration ctxRegistration;
    private ServiceListener queryListener;
    private ServiceListener attributeListener;
    private volatile ObjectName objectNameToListen;
    private ObjectName delegate;
    private MBeanServer mbeaBeanServer;
    private BundleContext bundleContext;
    private Properties conf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        this.conf = new Properties();
        URL configurationURL = new File(System.getProperty("jonas.base") + "/conf/wildcat.properties").toURI().toURL();
        InputStream instream = null;
        try {
            instream = configurationURL.openStream();
            this.conf.load(instream);
        }
        catch (IOException e) {
            logger.debug((Object)"Unable to open the file wildcat.properties", new Object[]{e});
        }
        finally {
            if (instream != null) {
                instream.close();
            }
        }
        String contextName = System.getProperty("jonas.name", "jonas") + "_wcat";
        this.conf.setProperty("org.ow2.wildcat.context_name", contextName);
        String oname = this.conf.getProperty("wildcat.osgi.oname");
        if (oname != null) {
            this.objectNameToListen = new ObjectName(oname);
            this.mbeaBeanServer = MBeanServerFactory.findMBeanServer(null).get(0);
        }
        if (this.mbeaBeanServer != null && !this.mbeaBeanServer.isRegistered(this.objectNameToListen)) {
            this.delegate = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            this.mbeaBeanServer.addNotificationListener(this.delegate, this, null, null);
        } else {
            this.doEffectiveStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEffectiveStart() throws Exception {
        if (this.ctx == null) {
            ClassLoader lastClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(Activator.class.getClassLoader());
            try {
                this.ctx = this.createContext();
            }
            finally {
                Thread.currentThread().setContextClassLoader(lastClassLoader);
            }
            this.queryListener = new QueryListener(this.bundleContext, this.ctx);
            this.bundleContext.addServiceListener(this.queryListener, "(objectClass=" + IQueryAdder.class.getName() + ")");
            this.attributeListener = new AttributeListener(this.bundleContext, this.ctx);
            this.bundleContext.addServiceListener(this.attributeListener, "(objectClass=" + IAttributeAttacher.class.getName() + ")");
            this.ctxRegistration = this.bundleContext.registerService(Context.class.getName(), (Object)this.ctx, null);
        }
    }

    private Context createContext() {
        Logger.getRootLogger().setLevel(Level.WARN);
        ContextFactory factory = new ContextFactory(this.conf);
        Context ctx = factory.createContext();
        try {
            ctx.export();
        }
        catch (ContextException e) {
            logger.warn((Object)"Unable to register the WildCAT context for remote connection!", new Object[0]);
        }
        logger.info((Object)"WildCAT context successfully created", new Object[0]);
        return ctx;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.delegate != null && this.mbeaBeanServer.isRegistered(this.delegate)) {
            this.mbeaBeanServer.removeNotificationListener(this.delegate, this);
        }
        this.ctx.unexport();
        if (this.ctxRegistration != null) {
            this.ctxRegistration.unregister();
        }
        if (this.attributeListener != null) {
            context.removeServiceListener(this.attributeListener);
        }
        if (this.queryListener != null) {
            context.removeServiceListener(this.queryListener);
        }
        this.ctx.destroy();
    }

    public void handleNotification(Notification notification, Object handback) {
        if (notification.getType().equals("JMX.mbean.registered")) {
            if (this.objectNameToListen.equals(((MBeanServerNotification)notification).getMBeanName())) {
                try {
                    this.doEffectiveStart();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (!notification.getType().equals("JMX.mbean.unregistered") || this.objectNameToListen.equals(((MBeanServerNotification)notification).getMBeanName())) {
            // empty if block
        }
    }
}

