/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.remote.dispatcher.rmi;

import java.rmi.Remote;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.wildcat.Context;
import org.ow2.wildcat.ContextFactory;
import org.ow2.wildcat.remote.dispatcher.AbstractDispatcher;
import org.ow2.wildcat.remote.dispatcher.DispatcherException;
import org.ow2.wildcat.remote.dispatcher.rmi.RMIRemoteContext;
import org.ow2.wildcat.remote.provider.JMSProviderException;
import org.ow2.wildcat.remote.provider.JNDIProvider;

public final class RMIDispatcher
extends AbstractDispatcher {
    private static Log logger = LogFactory.getLog(RMIDispatcher.class);
    private javax.naming.Context myContext = null;
    private final Map<String, TopicConnection> topicConnections = new HashMap<String, TopicConnection>();

    public RMIDispatcher(ContextFactory factory) throws DispatcherException {
        super(factory, true);
    }

    protected void doExport(Context context) throws DispatcherException {
        try {
            PortableRemoteObject.exportObject((Remote)((Remote)((Object)context)));
            this.myContext = new InitialContext();
            this.myContext.rebind(context.getName(), (Object)context);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to export the context with name " + context.getName()), (Throwable)e);
            throw new DispatcherException("Unable to export the context with name " + context.getName(), e);
        }
    }

    protected void doUnexport(Context context) throws DispatcherException {
        try {
            PortableRemoteObject.unexportObject((Remote)((Remote)((Object)context)));
            this.myContext.unbind(context.getName());
        }
        catch (Exception e) {
            logger.error((Object)("Unable to unexport the context with name " + context.getName()), (Throwable)e);
            throw new DispatcherException("Unable to unexport the context with name " + context.getName(), e);
        }
        finally {
            if (this.myContext != null) {
                try {
                    this.myContext.close();
                }
                catch (NamingException e) {
                    logger.debug((Object)"Unable to close the CMI context", (Throwable)e);
                }
            }
        }
    }

    protected RMIRemoteContext getRemoteContext(String alias) throws DispatcherException {
        try {
            return (RMIRemoteContext)this.myContext.lookup(alias);
        }
        catch (Exception e) {
            logger.debug((Object)("Unreachable context " + alias), (Throwable)e);
            throw new DispatcherException("Unreachable context " + alias, e);
        }
    }

    protected TopicConnection getTopicConnectionToListen(String source) throws DispatcherException {
        TopicConnection tc = this.topicConnections.get(source);
        if (tc == null) {
            try {
                TopicConnectionFactory tcf = ((RMIRemoteContext)this.lookup(source)).getTopicConnectionFactoryToSpy();
                tc = tcf.createTopicConnection();
                tc.start();
            }
            catch (Exception e) {
                logger.error((Object)"Unable to start a topic connection factory", (Throwable)e);
                throw new DispatcherException("Unable to start a topic connection factory", e);
            }
            this.topicConnections.put(source, tc);
        }
        return tc;
    }

    protected void stopTopicConnection(String source) throws DispatcherException {
        if (this.topicConnections.containsKey(source)) {
            try {
                this.topicConnections.remove(source).close();
            }
            catch (JMSException e) {
                logger.error((Object)("Unable to close the topic connection factory for " + source), (Throwable)e);
                throw new DispatcherException("Unable to close the topic connection factory for " + source, e);
            }
        }
    }

    protected Topic getTopicToListen(String source) throws DispatcherException {
        try {
            return ((RMIRemoteContext)this.lookup(source)).getTopicToSpy();
        }
        catch (Exception e) {
            logger.debug((Object)("Unable to get the topic with name " + source), (Throwable)e);
            throw new DispatcherException("Unable to get the topic with name " + source, e);
        }
    }

    public TopicConnectionFactory getRemoteTopicConnectionFactory() throws DispatcherException {
        try {
            return ((JNDIProvider)this.getJMSProvider()).getRemoteTopicConnectionFactory();
        }
        catch (JMSProviderException e) {
            logger.error((Object)"Unable to get a topic connection factory", (Throwable)e);
            throw new DispatcherException("Unable to get a topic connection factory", e);
        }
    }
}

