/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.sensors;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.wildcat.sensors.CPUInfoSensor;
import org.ow2.wildcat.sensors.CPULoadSensor;
import org.ow2.wildcat.sensors.DateTimeSensor;
import org.ow2.wildcat.sensors.JavaRuntimeSensor;
import org.ow2.wildcat.sensors.KernelVersionSensor;
import org.ow2.wildcat.sensors.NullSensor;
import org.ow2.wildcat.sensors.Sensor;
import org.ow2.wildcat.sensors.SystemPropertiesSensor;

public class SensorLibrary {
    private static Log logger = LogFactory.getLog(SensorLibrary.class);
    public static SensorLibrary DEFAULT;
    private Map<String, Class<? extends Sensor>> library = new HashMap<String, Class<? extends Sensor>>();

    public boolean contains(String sensor) {
        return this.library.containsKey(sensor);
    }

    public Sensor instanciate(String sensor) {
        try {
            return this.library.get(sensor).newInstance();
        }
        catch (Exception e) {
            logger.info((Object)("Failled instanciating sensor '" + sensor + "'"), (Throwable)e);
            return new NullSensor();
        }
    }

    static {
        try {
            DEFAULT = new SensorLibrary();
            SensorLibrary.DEFAULT.library.put("CPUInfo", CPUInfoSensor.class);
            SensorLibrary.DEFAULT.library.put("CPULoad", CPULoadSensor.class);
            SensorLibrary.DEFAULT.library.put("DateTime", DateTimeSensor.class);
            SensorLibrary.DEFAULT.library.put("JavaRuntime", JavaRuntimeSensor.class);
            SensorLibrary.DEFAULT.library.put("KernelVersion", KernelVersionSensor.class);
            SensorLibrary.DEFAULT.library.put("Null", NullSensor.class);
            SensorLibrary.DEFAULT.library.put("SystemProperties", SystemPropertiesSensor.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

