/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.hierarchy.resource;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.wildcat.Context;
import org.ow2.wildcat.ContextFactory;
import org.ow2.wildcat.event.WEventInterface;
import org.ow2.wildcat.event.WHierarchyEvent;
import org.ow2.wildcat.hierarchy.Mountable;
import org.ow2.wildcat.hierarchy.Path;
import org.ow2.wildcat.hierarchy.attribute.Attribute;
import org.ow2.wildcat.hierarchy.resource.Resource;
import org.ow2.wildcat.hierarchy.resource.ResourceException;
import org.ow2.wildcat.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalResource
implements Resource {
    private static Log logger = LogFactory.getLog(LocalResource.class);
    private final Map<String, Resource> children = new HashMap<String, Resource>();
    private final Map<String, Attribute> attributes = new HashMap<String, Attribute>();
    private Context context;
    private Path path;

    protected boolean hasResource(String name) {
        return this.children.containsKey(name);
    }

    protected boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    protected Resource getResource(String name) {
        return this.hasResource(name) ? this.children.get(name) : null;
    }

    protected Attribute getAttribute(String name) {
        return this.hasAttribute(name) ? this.attributes.get(name) : null;
    }

    protected void attachAttribute(String name, Attribute attribute) {
        attribute.mount(this.context, this.path.appendAttribute(name));
        if (this.isMount()) {
            this.attributes.put(name, attribute);
            this.context.emitEvent(new WHierarchyEvent(this.path, WHierarchyEvent.Type.ATTRIBUTE_ADDED, name));
        }
    }

    private void detachAttribute(String attributeName) {
        if (this.isMount()) {
            Attribute attribute = this.attributes.get(attributeName);
            attribute.unMount();
            this.attributes.remove(attributeName);
            this.context.emitEvent(new WHierarchyEvent(this.path, WHierarchyEvent.Type.ATTRIBUTE_REMOVED, attributeName));
        }
    }

    protected void attachResource(String name, Resource resource) {
        resource.mount(this.context, this.path.appendResource(name));
        if (this.isMount()) {
            this.children.put(name, resource);
            this.context.emitEvent(new WHierarchyEvent(this.path, WHierarchyEvent.Type.RESOURCE_ADDED, name));
        }
    }

    private void detachResource(String name) {
        if (this.isMount()) {
            Resource resource = this.children.get(name);
            resource.unMount();
            this.children.remove(name);
            this.context.emitEvent(new WHierarchyEvent(this.path, WHierarchyEvent.Type.RESOURCE_REMOVED, name));
        }
    }

    protected Resource findOrCreate(String name, boolean create) {
        Resource r = this.getResource(name);
        if (r == null && !this.hasAttribute(name) && create) {
            r = ContextFactory.getDefaultFactory().createResource();
            this.attachResource(name, r);
        }
        return r;
    }

    @Override
    public void attachAttribute(Path attribute, Attribute attr) throws ResourceException {
        if (attribute.isOnlyAttribute()) {
            this.attachAttribute(attribute.getAttributeName(), attr);
        } else {
            Resource resource = this.findOrCreate(attribute.getFirstResource(), true);
            if (resource == null) {
                logger.info((Object)("Can't create resource '" + attribute.getFirstResource() + "', ignoring"));
                return;
            }
            resource.attachAttribute(attribute.stripTop(), attr);
        }
    }

    @Override
    public void detachAttribute(Path attribute) throws ResourceException {
        if (attribute.isOnlyAttribute()) {
            this.detachAttribute(attribute.getAttributeName());
        } else {
            Resource resource = this.findOrCreate(attribute.getFirstResource(), false);
            if (resource == null) {
                logger.info((Object)("Can't create resource '" + attribute.getFirstResource() + "', ignoring"));
                return;
            }
            resource.detachAttribute(attribute.stripTop());
        }
    }

    @Override
    public void attachResource(Path resource, Resource res) throws ResourceException {
        if (resource.isOnlyResource()) {
            this.attachResource(resource.getFirstResource(), res);
        } else {
            Resource r = this.findOrCreate(resource.getFirstResource(), true);
            if (r == null) {
                logger.info((Object)("Can't create resource '" + resource.getFirstResource() + "', ignoring"));
                return;
            }
            r.attachResource(resource.stripTop(), res);
        }
    }

    @Override
    public void detachResource(Path resource) throws ResourceException {
        if (resource.isOnlyResource()) {
            this.detachResource(resource.getFirstResource());
        } else {
            Resource r = this.findOrCreate(resource.getFirstResource(), false);
            if (r == null) {
                logger.info((Object)("Can't create resource '" + resource.getFirstResource() + "', ignoring"));
                return;
            }
            r.detachResource(resource.stripTop());
        }
    }

    @Override
    public void createAttribute(Path attribute, WEventInterface.Scope scope, Object value) throws ResourceException {
        if (attribute.isOnlyAttribute()) {
            Attribute a = ContextFactory.getDefaultFactory().createAttribute(scope, value);
            this.attachAttribute(attribute.getAttributeName(), a);
        } else {
            Resource resource = this.findOrCreate(attribute.getFirstResource(), true);
            if (resource == null) {
                logger.info((Object)("Can't create resource '" + attribute.getFirstResource() + "', ignoring"));
                return;
            }
            resource.createAttribute(attribute.stripTop(), scope, value);
        }
    }

    @Override
    public Attribute getAttribute(Path attribute) throws ResourceException {
        if (attribute.isOnlyAttribute()) {
            return this.getAttribute(attribute.getAttributeName());
        }
        Resource resource = this.findOrCreate(attribute.getFirstResource(), false);
        if (resource == null) {
            return null;
        }
        return resource.getAttribute(attribute.stripTop());
    }

    @Override
    public void createResource(Path resource) throws ResourceException {
        if (resource == null) {
            return;
        }
        Resource r = this.findOrCreate(resource.getFirstResource(), true);
        if (r == null) {
            logger.info((Object)("Can't create resource '" + resource.getFirstResource() + "', ignoring"));
            return;
        }
        if (resource.isOnlyResource()) {
            return;
        }
        r.createResource(resource.stripTop());
    }

    @Override
    public Resource getResource(Path res) throws ResourceException {
        Resource r = this.findOrCreate(res.getFirstResource(), false);
        if (r == null) {
            return null;
        }
        if (res.isOnlyResource()) {
            return r;
        }
        return r.getResource(res.stripTop());
    }

    @Override
    public Object setValue(Path attr, Object value) throws ResourceException {
        if (attr.isOnlyAttribute()) {
            Attribute attribute = this.getAttribute(attr.getAttributeName());
            if (attribute == null) {
                logger.info((Object)("No attribute named '" + attr.getAttributeName() + "', return 'null'"));
                return null;
            }
            return attribute.setValue(value);
        }
        Resource resource = this.getResource(attr.getFirstResource());
        if (resource == null) {
            logger.warn((Object)("No resource named '" + attr.getFirstResource() + "', return 'null'"));
            return null;
        }
        return resource.setValue(attr.stripTop(), value);
    }

    @Override
    public Object getValue(Path attr) throws ResourceException {
        if (attr.isOnlyAttribute()) {
            Attribute attribute = this.getAttribute(attr.getAttributeName());
            if (attribute == null) {
                logger.info((Object)("No attribute named '" + attr.getAttributeName() + "', return 'null'"));
                return null;
            }
            return attribute.getValue();
        }
        Resource resource = this.getResource(attr.getFirstResource());
        if (resource == null) {
            logger.info((Object)("No resource named '" + attr.getFirstResource() + "', return 'null'"));
            return null;
        }
        return resource.getValue(attr.stripTop());
    }

    @Override
    public Set<String> list(Path resource) throws ResourceException {
        if (this.isMount()) {
            if (resource == null) {
                HashSet<String> r = new HashSet<String>();
                if (this.children != null) {
                    r.addAll(this.children.keySet());
                }
                for (String s : this.attributes.keySet()) {
                    r.add("#" + s);
                }
                return r;
            }
            Resource res = this.getResource(resource.getFirstResource());
            if (res == null) {
                logger.debug((Object)("No resource named '" + resource.getFirstResource() + "', return 'null'"));
                return null;
            }
            if (resource.isOnlyResource()) {
                return res.list(null);
            }
            return res.list(resource.stripTop());
        }
        return new HashSet<String>();
    }

    @Override
    public boolean isMount() {
        return this.context != null && this.path != null;
    }

    @Override
    public void mount(Context context, Path mountPoint) {
        logger.debug((Object)Messages.message(Mountable.class.getName() + ".mount", mountPoint));
        if (this.isMount()) {
            logger.info((Object)Messages.message(Mountable.class.getName() + ".alreadymount", mountPoint));
        } else {
            this.context = context;
            this.path = mountPoint;
        }
    }

    @Override
    public void unMount() {
        logger.debug((Object)Messages.message(Mountable.class.getName() + ".unmount", null));
        if (this.children != null) {
            for (Map.Entry<String, Mountable> entry : this.children.entrySet()) {
                ((Resource)entry.getValue()).unMount();
                if (!this.isMount()) continue;
                this.context.emitEvent(new WHierarchyEvent(this.path, WHierarchyEvent.Type.RESOURCE_REMOVED, entry.getKey()));
            }
        }
        if (this.attributes != null) {
            for (Map.Entry<String, Mountable> entry : this.attributes.entrySet()) {
                ((Attribute)entry.getValue()).unMount();
                if (!this.isMount()) continue;
                this.context.emitEvent(new WHierarchyEvent(this.path, WHierarchyEvent.Type.ATTRIBUTE_REMOVED, entry.getKey()));
            }
        }
        this.context = null;
        this.path = null;
    }
}

