/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.hierarchy.resource;

import com.espertech.esper.client.UpdateListener;
import com.espertech.esper.event.EventBean;
import java.text.MessageFormat;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.wildcat.Context;
import org.ow2.wildcat.ContextException;
import org.ow2.wildcat.Query;
import org.ow2.wildcat.event.WEvent;
import org.ow2.wildcat.event.WEventInterface;
import org.ow2.wildcat.event.WHierarchyEvent;
import org.ow2.wildcat.hierarchy.MalformedPathException;
import org.ow2.wildcat.hierarchy.Mountable;
import org.ow2.wildcat.hierarchy.Path;
import org.ow2.wildcat.hierarchy.attribute.Attribute;
import org.ow2.wildcat.hierarchy.resource.Resource;
import org.ow2.wildcat.hierarchy.resource.ResourceException;
import org.ow2.wildcat.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Symlink
implements Resource,
UpdateListener {
    private static Log logger = LogFactory.getLog(Symlink.class);
    private static String EVT_REROUTE = "select * from WEvent (org.ow2.wildcat.util.Helper.isPrefix(source, \"{0}\"))";
    private Context context;
    private Path path;
    private final Path target;
    private Query query;

    public Symlink(Path target) {
        this.target = target;
    }

    private Path addPrefix(Path suffix) {
        return this.target.append(suffix);
    }

    @Override
    public void attachAttribute(Path attribute, Attribute attr) throws ResourceException {
        try {
            this.context.attachAttribute(this.addPrefix(attribute).toString(), attr);
        }
        catch (ContextException e) {
            logger.error((Object)("Unable to attach an attribute at path " + this.path), (Throwable)e);
            throw new ResourceException("Unable to attach an attribute at path " + this.path, e);
        }
    }

    @Override
    public void attachResource(Path resource, Resource res) throws ResourceException {
        try {
            this.context.attachResource(this.addPrefix(resource).toString(), res);
        }
        catch (ContextException e) {
            logger.error((Object)("Unable to attach a resource at path " + this.path), (Throwable)e);
            throw new ResourceException("Unable to attach a resource at path " + this.path, e);
        }
    }

    @Override
    public void createAttribute(Path attribute, WEventInterface.Scope scope, Object value) throws ResourceException {
        try {
            this.context.createAttribute(this.addPrefix(attribute).toString(), scope, value);
        }
        catch (ContextException e) {
            logger.error((Object)("Unable to create an attribute at path " + this.path), (Throwable)e);
            throw new ResourceException("Unable to create an attribute at path " + this.path, e);
        }
    }

    @Override
    public Attribute getAttribute(Path attribute) throws ResourceException {
        try {
            return this.context.getAttribute(this.addPrefix(attribute).toString());
        }
        catch (ContextException e) {
            logger.error((Object)("Unable to get an attribute at path " + this.path), (Throwable)e);
            throw new ResourceException("Unable get an attribute at path " + this.path, e);
        }
    }

    @Override
    public void detachAttribute(Path attribute) throws ResourceException {
        try {
            this.context.detachAttribute(this.addPrefix(attribute).toString());
        }
        catch (ContextException e) {
            logger.error((Object)("Unable to detach an attribute at path " + this.path), (Throwable)e);
            throw new ResourceException("Unable detach an attribute at path " + this.path, e);
        }
    }

    @Override
    public void createResource(Path resource) throws ResourceException {
        try {
            this.context.createResource(this.addPrefix(resource).toString());
        }
        catch (ContextException e) {
            logger.error((Object)("Unable to create a resource at path " + this.path), (Throwable)e);
            throw new ResourceException("Unable to create a resource at path " + this.path, e);
        }
    }

    @Override
    public void detachResource(Path resource) throws ResourceException {
        try {
            this.context.detachAttribute(this.addPrefix(resource).toString());
        }
        catch (ContextException e) {
            logger.error((Object)("Unable to detach a resource at path " + this.path), (Throwable)e);
            throw new ResourceException("Unable detach a resource at path " + this.path, e);
        }
    }

    @Override
    public Resource getResource(Path res) throws ResourceException {
        try {
            return this.context.getResource(this.addPrefix(res).toString());
        }
        catch (ContextException e) {
            logger.error((Object)("Unable to get a resource at path " + this.path), (Throwable)e);
            throw new ResourceException("Unable to get a resource at path " + this.path, e);
        }
    }

    @Override
    public Object getValue(Path path) throws ResourceException {
        try {
            return this.context.getValue(this.addPrefix(path).toString());
        }
        catch (ContextException e) {
            logger.error((Object)("Unable to get a value at path " + path), (Throwable)e);
            throw new ResourceException("Unable to get a value at path " + path, e);
        }
    }

    public final Path getTarget() {
        return this.target;
    }

    @Override
    public Set<String> list(Path resource) throws ResourceException {
        try {
            return this.context.list(this.addPrefix(resource).toString());
        }
        catch (ContextException e) {
            logger.error((Object)("Unable to list a resource at path " + this.path), (Throwable)e);
            throw new ResourceException("Unable to list a resource at path " + this.path, e);
        }
    }

    @Override
    public Object setValue(Path path, Object value) throws ResourceException {
        try {
            return this.context.setValue(this.addPrefix(path).toString(), value);
        }
        catch (ContextException e) {
            logger.error((Object)("Unable to set a value at path " + path), (Throwable)e);
            throw new ResourceException("Unable to set a value at path " + path, e);
        }
    }

    @Override
    public boolean isMount() {
        return this.context != null && this.path != null;
    }

    @Override
    public void mount(Context context, Path mountPoint) {
        logger.debug((Object)Messages.message(Mountable.class.getName() + ".mount", mountPoint));
        if (this.isMount()) {
            logger.info((Object)Messages.message(Mountable.class.getName() + ".alreadymount", mountPoint));
        } else {
            this.context = context;
            this.path = mountPoint;
            this.context.emitEvent(new WHierarchyEvent(this.path, WHierarchyEvent.Type.LINKED, this.target.toString()));
            this.query = this.context.registerListeners(MessageFormat.format(EVT_REROUTE, this.target.toString()), this);
        }
    }

    @Override
    public void unMount() {
        logger.debug((Object)Messages.message(Mountable.class.getName() + ".unmount", null));
        if (!this.isMount()) {
            logger.info((Object)Messages.message(Mountable.class.getName() + ".notmount", null));
        } else {
            this.context.emitEvent(new WHierarchyEvent(this.path, WHierarchyEvent.Type.UNLINKED, this.target.toString()));
            if (this.query != null) {
                this.context.destroyQuery(this.query);
                this.query = null;
            }
            this.context = null;
            this.path = null;
        }
    }

    public void update(EventBean[] arg0, EventBean[] arg1) {
        for (EventBean bean : arg0) {
            if (!(bean.getUnderlying() instanceof WEvent)) continue;
            try {
                WEvent evt = (WEvent)((WEvent)bean.getUnderlying()).clone();
                Path s = new Path(evt.getSource());
                evt.setSource(s.replacePrefix(this.target, this.path));
                if (!this.isMount()) continue;
                this.context.emitEvent(evt);
            }
            catch (CloneNotSupportedException e) {
                logger.fatal((Object)"REALLY BIG TROUBLE", (Throwable)e);
            }
            catch (MalformedPathException e) {
                logger.fatal((Object)"REALLY BIG TROUBLE", (Throwable)e);
            }
        }
    }
}

