/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.osgi;

import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.wildcat.Context;
import org.ow2.wildcat.Query;
import org.ow2.wildcat.hierarchy.ListenerRegistrationException;
import org.ow2.wildcat.osgi.api.IQueryAdder;

public class QueryListener
implements ServiceListener {
    private static Log logger = LogFactory.getLog(QueryListener.class);
    private final BundleContext context;
    private final Context ctx;
    private final Map<ServiceReference, Query> queries = new HashMap<ServiceReference, Query>();

    public QueryListener(BundleContext bundleContext, Context ctx) {
        this.context = bundleContext;
        this.ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void serviceChanged(ServiceEvent event) {
        ClassLoader lastClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(QueryListener.class.getClassLoader());
        try {
            ServiceReference ref = event.getServiceReference();
            switch (event.getType()) {
                case 1: {
                    IQueryAdder queryAdder = (IQueryAdder)this.context.getService(ref);
                    try {
                        this.queries.put(ref, queryAdder.registerListener(this.ctx));
                        logger.info((Object)"WildCAT Query succesfully registered: {0}", new Object[]{queryAdder.getQuery()});
                        return;
                    }
                    catch (ListenerRegistrationException e) {
                        logger.warn((Object)"Unable to add the WildCAT query: {0}", new Object[]{queryAdder.getQuery()});
                        return;
                    }
                }
                case 4: {
                    Query query = this.queries.remove(ref);
                    if (query == null) return;
                    this.ctx.destroyQuery(query);
                    logger.info((Object)"WildCAT Query succesfully unregistered: {0}", new Object[]{query});
                    return;
                }
            }
            return;
        }
        finally {
            Thread.currentThread().setContextClassLoader(lastClassLoader);
        }
    }
}

