/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.remote.dispatcher;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.wildcat.Context;
import org.ow2.wildcat.ContextFactory;
import org.ow2.wildcat.event.WEvent;
import org.ow2.wildcat.remote.ContextEvent;
import org.ow2.wildcat.remote.RemoteContext;
import org.ow2.wildcat.remote.dispatcher.DispatcherException;
import org.ow2.wildcat.remote.dispatcher.Export;
import org.ow2.wildcat.remote.dispatcher.IDispatcher;
import org.ow2.wildcat.remote.dispatcher.TopicToSpy;
import org.ow2.wildcat.remote.provider.JMSProvider;
import org.ow2.wildcat.remote.provider.JNDIProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDispatcher
implements IDispatcher,
MessageListener {
    private static Log logger = LogFactory.getLog(AbstractDispatcher.class);
    private final ContextFactory factory;
    private JMSProvider jmsProvider;
    private final TopicSession sessionToPublish;
    private final TopicConnection topicConnection;
    private final Map<String, Export> exports;
    private final Map<String, TopicToSpy> listeners;
    private Map<String, RemoteContext> remoteContextsCache;

    protected AbstractDispatcher(ContextFactory factory, boolean local) throws DispatcherException {
        this.factory = factory;
        this.exports = new HashMap<String, Export>();
        this.listeners = new HashMap<String, TopicToSpy>();
        this.remoteContextsCache = new HashMap<String, RemoteContext>();
        this.jmsProvider = new JNDIProvider(factory.getJMSProviderDelegate(), local);
        try {
            this.jmsProvider.init(factory);
            TopicConnectionFactory connectionFactory = this.jmsProvider.getTopicConnectionFactory();
            this.topicConnection = connectionFactory.createTopicConnection();
            this.topicConnection.start();
            this.sessionToPublish = this.topicConnection.createTopicSession(false, 1);
        }
        catch (Exception e) {
            logger.error((Object)"Unable to initialize the JMS connection", new Object[]{e});
            throw new DispatcherException("Unable to initialize the JMS connection", e);
        }
    }

    @Override
    public final void export(Context context) throws DispatcherException {
        if (!this.exports.containsKey(context.getName())) {
            String topicName = this.factory.computeTopicJNDIName(context.getName());
            try {
                Topic topicToPublish = this.jmsProvider.getTopic(topicName);
                TopicPublisher publisher = this.sessionToPublish.createPublisher(topicToPublish);
                this.exports.put(context.getName(), new Export(context, topicToPublish, publisher));
            }
            catch (Exception e) {
                logger.error((Object)("Unable to retrieve the topic with name " + topicName), new Object[]{e});
                throw new DispatcherException("Unable to retrieve the topic with name " + topicName, e);
            }
            this.doExport(context);
            logger.info((Object)("The context " + context.getName() + " is now exported."), new Object[0]);
        }
    }

    protected abstract void doExport(Context var1) throws DispatcherException;

    @Override
    public final synchronized boolean listen(Context listener, String source) {
        Set<Context> tts;
        TopicToSpy ls = this.listeners.get(source);
        if (ls == null) {
            try {
                Topic topicToListen = this.getTopicToListen(source);
                TopicConnection connectionToListen = this.getTopicConnectionToListen(source);
                TopicSession sessionToListen = connectionToListen.createTopicSession(false, 1);
                TopicSubscriber consumer = sessionToListen.createSubscriber(topicToListen);
                consumer.setMessageListener((MessageListener)this);
                ls = new TopicToSpy(topicToListen, consumer, sessionToListen);
            }
            catch (Exception e) {
                logger.error((Object)("Unable to retrieve the topic with name " + source), new Object[]{e});
                return false;
            }
            this.listeners.put(source, ls);
        }
        if (!(tts = ls.getSpyingContexts()).contains(listener)) {
            tts.add(listener);
        } else {
            logger.debug((Object)("Context '" + source + "' already spied, ignoring"), new Object[0]);
        }
        return true;
    }

    @Override
    public final synchronized void notifyEvent(Context sender, WEvent ... events) {
        Export export = this.exports.get(sender.getName());
        if (export != null) {
            try {
                ObjectMessage message = this.sessionToPublish.createObjectMessage((Serializable)new ContextEvent(sender.getName(), events));
                export.getPublisher().publish((Message)message);
            }
            catch (JMSException e) {
                logger.warn((Object)"Unable to publish the event {0} coming from {1}", new Object[]{Arrays.asList(events), sender.getName(), e});
            }
        }
    }

    @Override
    public final synchronized RemoteContext lookup(String alias) throws DispatcherException {
        RemoteContext ctx = this.remoteContextsCache.get(alias);
        if (ctx == null) {
            ctx = this.getRemoteContext(alias);
            this.remoteContextsCache.put(alias, ctx);
        }
        return ctx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onMessage(Message message) {
        if (message instanceof ObjectMessage) {
            try {
                ContextEvent contextEvent;
                Set<Context> ls;
                Serializable obj = ((ObjectMessage)message).getObject();
                if (!(obj instanceof ContextEvent) || (ls = this.getListeners((contextEvent = (ContextEvent)obj).getSender())) == null) return;
                for (Context l : ls) {
                    l.emitEvent(contextEvent.getEvents());
                }
                return;
            }
            catch (Exception e) {
                logger.warn((Object)"pb: ", new Object[]{e});
                return;
            }
        } else {
            logger.warn((Object)"pb: not instance of ObjectMessage: {0}", new Object[]{message});
        }
    }

    public Topic getExportedTopic(String name) {
        return this.exports.get(name).getTopic();
    }

    @Override
    public void doNotListen(Context me, String source) {
        Set<Context> spyingContexts;
        TopicToSpy tts = this.listeners.remove(source);
        if (tts != null && (spyingContexts = tts.getSpyingContexts()).remove(me) && spyingContexts.isEmpty()) {
            try {
                tts.getConsumer().close();
            }
            catch (JMSException e) {
                logger.warn((Object)("Unable to close the consumer for " + source), new Object[]{e});
            }
            try {
                this.stopTopicConnection(source);
            }
            catch (DispatcherException e) {
                logger.warn((Object)("Unable to stop the connection for " + source), new Object[]{e});
            }
        }
    }

    @Override
    public void unexport(Context context) throws DispatcherException {
        this.doUnexport(context);
        Export export = this.exports.remove(context.getName());
        if (export != null) {
            try {
                export.getPublisher().close();
                this.jmsProvider.deleteTopic(this.factory.computeTopicJNDIName(export.getTopic().getTopicName()));
            }
            catch (Exception e) {
                logger.error((Object)("Error while unexporting the context with name " + context.getName()), new Object[]{e});
                throw new DispatcherException("Error while unexporting the context with name" + context.getName(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean isRemoteContextAvailable(String context) {
        boolean bl;
        TopicSession sessionToListen;
        block11: {
            sessionToListen = null;
            Topic topicToListen = this.getTopicToListen(context);
            TopicConnection connectionToListen = this.getTopicConnectionToListen(context);
            sessionToListen = connectionToListen.createTopicSession(false, 1);
            TopicSubscriber consumer = sessionToListen.createSubscriber(topicToListen);
            consumer.close();
            bl = true;
            if (sessionToListen == null) break block11;
            try {
                sessionToListen.close();
            }
            catch (JMSException e) {
                logger.debug((Object)"Cannot close a session", new Object[]{e});
            }
        }
        return bl;
        catch (Exception e) {
            boolean bl2;
            block12: {
                try {
                    logger.debug((Object)("Unable to create a subscriber for the context with name " + context), new Object[]{e});
                    bl2 = false;
                    if (sessionToListen == null) break block12;
                }
                catch (Throwable throwable) {
                    if (sessionToListen != null) {
                        try {
                            sessionToListen.close();
                        }
                        catch (JMSException e2) {
                            logger.debug((Object)"Cannot close a session", new Object[]{e2});
                        }
                    }
                    throw throwable;
                }
                try {
                    sessionToListen.close();
                }
                catch (JMSException e3) {
                    logger.debug((Object)"Cannot close a session", new Object[]{e3});
                }
            }
            return bl2;
        }
    }

    protected abstract void doUnexport(Context var1) throws DispatcherException;

    protected final ContextFactory getFactory() {
        return this.factory;
    }

    protected final Set<Context> getListeners(String sender) {
        return this.listeners.get(sender).getSpyingContexts();
    }

    protected final Context getExportedContext(String name) {
        return this.exports.get(name).getContext();
    }

    protected TopicConnection getTopicConnectionToListen(String source) throws DispatcherException {
        return this.topicConnection;
    }

    protected void stopTopicConnection(String source) throws DispatcherException {
    }

    protected Topic getTopicToListen(String source) throws DispatcherException {
        String topicName = this.factory.computeTopicName(source);
        try {
            return this.sessionToPublish.createTopic(topicName);
        }
        catch (JMSException e) {
            logger.error((Object)("Unable to create the topic with name " + topicName), new Object[]{e});
            throw new DispatcherException("Unable to create the topic with name " + topicName, e);
        }
    }

    protected abstract RemoteContext getRemoteContext(String var1) throws DispatcherException;

    protected JMSProvider getJMSProvider() {
        return this.jmsProvider;
    }
}

