/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.remote.dispatcher.jms;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.wildcat.Context;
import org.ow2.wildcat.ContextFactory;
import org.ow2.wildcat.event.WEventInterface;
import org.ow2.wildcat.remote.dispatcher.AbstractDispatcher;
import org.ow2.wildcat.remote.dispatcher.DispatcherException;
import org.ow2.wildcat.remote.dispatcher.jms.ContextOperation;
import org.ow2.wildcat.remote.dispatcher.jms.ContextOperationResult;
import org.ow2.wildcat.remote.dispatcher.jms.JMSRemoteContext;

public class JMSDispatcher
extends AbstractDispatcher {
    private static Log logger = LogFactory.getLog(JMSDispatcher.class);
    private final String name;
    private final Map<Long, ContextOperationResult> pendingRemoteContextOperation;
    private long id = 0L;
    private final QueueSession sessionToReceiveRequests;
    private final QueueSession sessionToSendRequests;
    private final QueueSession sessionToReceiveResponses;
    private final QueueSession sessionToSendResponses;
    private final QueueReceiver responseQueueReceiver;
    private final Map<String, RemoteContextOperationListener> listeners;

    public JMSDispatcher(ContextFactory factory) throws DispatcherException {
        super(factory, false);
        this.name = factory.getProperty("org.ow2.wildcat.remote.dispatcher_name");
        this.pendingRemoteContextOperation = new HashMap<Long, ContextOperationResult>();
        this.listeners = new HashMap<String, RemoteContextOperationListener>();
        try {
            QueueConnectionFactory qcf = this.getJMSProvider().getQueueConnectionFactory();
            QueueConnection qc = qcf.createQueueConnection();
            qc.start();
            this.sessionToReceiveRequests = qc.createQueueSession(false, 1);
            this.sessionToReceiveResponses = qc.createQueueSession(false, 1);
            this.sessionToSendRequests = qc.createQueueSession(false, 1);
            this.sessionToSendResponses = qc.createQueueSession(false, 1);
            Queue rq = this.getJMSProvider().getQueue(this.name);
            this.responseQueueReceiver = this.sessionToReceiveResponses.createReceiver(rq);
            this.responseQueueReceiver.setMessageListener((MessageListener)new ContextOperationListener());
        }
        catch (Exception e) {
            logger.error((Object)"Failed connecting JMS registry", (Throwable)e);
            throw new DispatcherException("Failed connecting JMS registry", e);
        }
    }

    public void doExport(Context context) throws DispatcherException {
        try {
            Queue q = this.getJMSProvider().getQueue(context.getName() + "_requests");
            QueueReceiver qr = this.sessionToReceiveRequests.createReceiver(q);
            qr.setMessageListener((MessageListener)new ContextOperationListener());
            RemoteContextOperationListener listener = new RemoteContextOperationListener(q, qr);
            this.listeners.put(context.getName(), listener);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to export the context with name " + context.getName()), (Throwable)e);
            throw new DispatcherException("Unable to export the context with name " + context.getName(), e);
        }
    }

    protected JMSRemoteContext getRemoteContext(String alias) {
        return new JMSRemoteContext(this, alias);
    }

    public ContextOperationResult doRemoteContextOperation(ContextOperation co) throws DispatcherException {
        try {
            long coId = this.getNewId();
            co.setId(coId);
            co.setReturnQueue(this.name);
            Queue cq = this.sessionToSendRequests.createQueue(co.getTarget() + "_requests");
            QueueSender cqs = this.sessionToSendRequests.createSender(cq);
            cqs.setDeliveryMode(1);
            ObjectMessage c = this.sessionToSendRequests.createObjectMessage((Serializable)co);
            cqs.send((Message)c);
            this.pendingRemoteContextOperation.put(coId, null);
            while (this.pendingRemoteContextOperation.get(coId) == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.pendingRemoteContextOperation.remove(coId);
        }
        catch (JMSException e) {
            logger.error((Object)("Unable to perform a remote invocation with the context operation: " + co), (Throwable)e);
            throw new DispatcherException("Unable to perform a remote invocation with the context operation: " + co, e);
        }
    }

    private long getNewId() {
        return this.id++ % Long.MAX_VALUE;
    }

    protected void doUnexport(Context context) throws DispatcherException {
        RemoteContextOperationListener listener = this.listeners.remove(context.getName());
        if (listener != null) {
            try {
                listener.receiver.close();
                this.getJMSProvider().deleteQueue(listener.queue.getQueueName());
            }
            catch (Exception e) {
                logger.error((Object)("Error while unexporting the context with name " + context.getName()), (Throwable)e);
                throw new DispatcherException("Error while unexporting the context with name" + context.getName(), e);
            }
        }
    }

    private static class RemoteContextOperationListener {
        private final Queue queue;
        private final QueueReceiver receiver;

        RemoteContextOperationListener(Queue queue, QueueReceiver receiver) {
            this.queue = queue;
            this.receiver = receiver;
        }
    }

    private class ContextOperationListener
    implements MessageListener {
        private ContextOperationListener() {
        }

        public void onMessage(Message msg) {
            if (msg instanceof ObjectMessage) {
                Serializable obj = null;
                try {
                    obj = ((ObjectMessage)msg).getObject();
                    if (obj instanceof ContextOperation) {
                        ContextOperation co = (ContextOperation)obj;
                        Context callee = JMSDispatcher.this.getExportedContext(co.getTarget());
                        Method method = null;
                        switch (co.getOp()) {
                            case GET_VALUE: {
                                method = callee.getClass().getMethod("getValue", String.class);
                                break;
                            }
                            case SET_VALUE: {
                                method = callee.getClass().getMethod("setValue", String.class, Object.class);
                                break;
                            }
                            case CREATE_ATTRIBUTE: {
                                method = callee.getClass().getMethod("createAttribute", String.class, WEventInterface.Scope.class, Object.class);
                                break;
                            }
                            case CREATE_RESOURCE: {
                                method = callee.getClass().getMethod("createResource", String.class);
                                break;
                            }
                            case CREATE_SYMLINK: {
                                method = callee.getClass().getMethod("createSymlink", String.class, String.class);
                                break;
                            }
                            case LIST: {
                                method = callee.getClass().getMethod("list", String.class);
                            }
                        }
                        ContextOperationResult cor = new ContextOperationResult();
                        cor.setId(co.getId());
                        cor.setResult(method.invoke((Object)callee, co.getArgs()));
                        Queue rq = JMSDispatcher.this.sessionToSendResponses.createQueue(co.getReturnQueue());
                        QueueSender rqs = JMSDispatcher.this.sessionToSendResponses.createSender(rq);
                        rqs.setDeliveryMode(1);
                        ObjectMessage r = JMSDispatcher.this.sessionToSendResponses.createObjectMessage((Serializable)cor);
                        rqs.send((Message)r);
                        return;
                    }
                    if (obj instanceof ContextOperationResult) {
                        ContextOperationResult cor = (ContextOperationResult)obj;
                        JMSDispatcher.this.pendingRemoteContextOperation.put(cor.getId(), cor);
                        return;
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("Error when processing a received message: " + msg), (Throwable)e);
                }
            }
            logger.warn((Object)"Unexpected message type");
        }
    }
}

