/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.remote.provider.joram;

import fr.dyade.aaa.agent.AgentServer;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.User;
import org.objectweb.joram.client.jms.tcp.QueueTcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TopicTcpConnectionFactory;

public final class JORAMServer {
    private final short id;
    private final String hostname;
    private final int port;
    private final String topicConnectionFactoryName;
    private final String queueConnectionFactoryName;

    public JORAMServer() {
        this(0, "localhost", 16010, "JTCF", "JQCF");
    }

    public JORAMServer(short id, String hostname, int port, String topicConnectionFactoryName, String queueConnectionFactoryName) {
        this.id = id;
        this.hostname = hostname;
        this.port = port;
        this.topicConnectionFactoryName = topicConnectionFactoryName;
        this.queueConnectionFactoryName = queueConnectionFactoryName;
    }

    public void start() throws Exception {
        String[] args = new String[]{Short.toString(this.id), "./s" + this.id};
        AgentServer.main((String[])args);
        AdminModule.collocatedConnect((String)"root", (String)"root");
        TopicConnectionFactory topicConnectionFactory = TopicTcpConnectionFactory.create((String)this.hostname, (int)this.port);
        QueueConnectionFactory queueConnectionFactory = QueueTcpConnectionFactory.create((String)this.hostname, (int)this.port);
        InitialContext context = new InitialContext();
        context.rebind(this.topicConnectionFactoryName, (Object)topicConnectionFactory);
        context.rebind(this.queueConnectionFactoryName, (Object)queueConnectionFactory);
        context.close();
        User.create((String)"anonymous", (String)"anonymous", (int)0);
    }

    public void stop() throws Exception {
        InitialContext context = new InitialContext();
        context.unbind(this.topicConnectionFactoryName);
        context.unbind(this.queueConnectionFactoryName);
        context.close();
        AgentServer.stop();
    }

    public static void main(String[] args) throws Exception {
        JORAMServer server = new JORAMServer();
        server.start();
    }
}

