/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.osgi;

import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.wildcat.Context;
import org.ow2.wildcat.ContextException;
import org.ow2.wildcat.osgi.api.IAttributeAttacher;

public class AttributeListener
implements ServiceListener {
    private static Log logger = LogFactory.getLog(AttributeListener.class);
    private final BundleContext context;
    private final Context ctx;
    private final Map<ServiceReference, String> paths = new HashMap<ServiceReference, String>();

    public AttributeListener(BundleContext bundleContext, Context ctx) {
        this.context = bundleContext;
        this.ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void serviceChanged(ServiceEvent event) {
        ClassLoader lastClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(AttributeListener.class.getClassLoader());
        try {
            ServiceReference ref = event.getServiceReference();
            switch (event.getType()) {
                case 1: {
                    IAttributeAttacher attacher = (IAttributeAttacher)this.context.getService(ref);
                    try {
                        this.ctx.attachAttribute(attacher.getPath(), attacher.getAttribute());
                        logger.info((Object)"WildCAT Attribute succesfully attached at path {0}", new Object[]{attacher.getPath()});
                    }
                    catch (ContextException e) {
                        logger.warn((Object)("Unable to attach a WildCAT attribute at path " + attacher.getPath()), new Object[]{e});
                    }
                    this.paths.put(ref, attacher.getPath());
                    return;
                }
                case 4: {
                    String path = this.paths.remove(ref);
                    if (path == null) return;
                    try {
                        this.ctx.detachAttribute(path);
                        logger.info((Object)"WildCAT Attribute succesfully detached at path {0}", new Object[]{path});
                        return;
                    }
                    catch (ContextException e) {
                        logger.warn((Object)("Unable to detach a WildCAT attribute at path " + path), new Object[]{e});
                        return;
                    }
                }
            }
            return;
        }
        finally {
            Thread.currentThread().setContextClassLoader(lastClassLoader);
        }
    }
}

