/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.sensors;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.ow2.wildcat.sensors.Sensor;
import org.ow2.wildcat.sensors.TextFileSensor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CPUInfoSensor
extends TextFileSensor
implements Sensor {
    private static final long serialVersionUID = -4876635381240076523L;
    private static final TextFileSensor.LineFormat[] LINE_FORMATS = new TextFileSensor.LineFormat[]{new TextFileSensor.LineFormat("processor", "processor\t: {0,number,integer}"), new TextFileSensor.LineFormat("vendor_id", "vendor_id\t: {0}"), new TextFileSensor.LineFormat("cpu_family", "cpu family\t: {0,number,integer}"), new TextFileSensor.LineFormat("model", "model\t\t: {0,number,integer}"), new TextFileSensor.LineFormat("model_name", "model name\t: {0}"), new TextFileSensor.LineFormat("stepping", "stepping\t: {0,number,integer}"), new TextFileSensor.LineFormat("speed", "cpu MHz\t\t: {0,number}"), new TextFileSensor.LineFormat("cache", "cache size\t: {0,number,integer} KB")};

    public CPUInfoSensor() {
        super("/proc/cpuinfo");
    }

    @Override
    protected Map<String, Object> getValues(String[] lines) {
        HashMap<String, Object> samples = new HashMap<String, Object>();
        for (int i = 0; i < LINE_FORMATS.length; ++i) {
            String name = LINE_FORMATS[i].getProperty();
            Object value = null;
            try {
                value = ((Object[])LINE_FORMATS[i].getFormat().parseObject(lines[i]))[0];
            }
            catch (ParseException e) {
                // empty catch block
            }
            if (value instanceof Number) {
                samples.put(name, value);
                continue;
            }
            if (value instanceof String) {
                samples.put(name, value);
                continue;
            }
            if (value instanceof Boolean) {
                samples.put(name, value);
                continue;
            }
            throw new RuntimeException("Should not happen.");
        }
        return samples;
    }
}

