/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.remote.provider.joram;

import java.net.ConnectException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.Topic;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.local.LocalConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TcpConnectionFactory;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.wildcat.ContextFactory;
import org.ow2.wildcat.remote.provider.JMSProvider;
import org.ow2.wildcat.remote.provider.JMSProviderException;
import org.ow2.wildcat.remote.provider.joram.JORAMServer;

public final class JORAMProvider
implements JMSProvider {
    private static Log logger = LogFactory.getLog(JORAMProvider.class);
    private JORAMServer joramServer = null;
    private Map<String, Destination> createdDestinations = new HashMap<String, Destination>();
    private ContextFactory contextFactory;

    public void init(ContextFactory contextFactory) throws JMSProviderException {
        this.contextFactory = contextFactory;
        String hostname = contextFactory.getProperty("org.ow2.wildcat.jms.provider.joram.hostname");
        int port = Integer.parseInt(contextFactory.getProperty("org.ow2.wildcat.jms.provider.joram.port"));
        if (!this.isJORAMServerAvailable()) {
            if (contextFactory.isEmbedded()) {
                short id = Short.parseShort(contextFactory.getProperty("org.ow2.wildcat.jms.provider.joram.id"));
                this.joramServer = new JORAMServer(id, hostname, port, contextFactory.getProperty("org.ow2.wildcat.remote.topic_connection_factory"), contextFactory.getProperty("org.ow2.wildcat.remote.queue_connection_factory"));
                try {
                    this.joramServer.start();
                }
                catch (Exception e) {
                    logger.error((Object)"Cannot start the JORAM server", new Object[]{e});
                    throw new JMSProviderException("Cannot start the JORAM server", e);
                }
            } else {
                logger.error((Object)"Cannot connect to the admin module", new Object[0]);
                throw new JMSProviderException("Cannot connect to the admin module");
            }
        }
    }

    private boolean isJORAMServerAvailable() {
        if (this.contextFactory.isEmbedded()) {
            try {
                AdminModule.collocatedConnect((String)"root", (String)"root");
            }
            catch (Exception e) {
                logger.debug((Object)"Cannot connect to the collocated JORAM server", new Object[0]);
                logger.debug((Object)"cause: ", new Object[]{e});
                return false;
            }
        }
        String hostname = this.contextFactory.getProperty("org.ow2.wildcat.jms.provider.joram.hostname");
        int port = Integer.parseInt(this.contextFactory.getProperty("org.ow2.wildcat.jms.provider.joram.port"));
        try {
            AdminModule.connect((String)hostname, (int)port, (String)"root", (String)"root", (int)10);
        }
        catch (Exception e) {
            logger.debug((Object)"Cannot connect to the JORAM server at host {0} with port {1}", new Object[]{hostname, port});
            logger.debug((Object)"cause: ", new Object[]{e});
            return false;
        }
        return true;
    }

    public ConnectionFactory getTopicConnectionFactory() throws JMSProviderException {
        if (this.contextFactory.isEmbedded()) {
            return LocalConnectionFactory.create();
        }
        try {
            return TcpConnectionFactory.create();
        }
        catch (ConnectException e) {
            logger.error((Object)"Unable to create a topic connection factory", new Object[]{e});
            throw new JMSProviderException("Unable to create a topic connection factory", e);
        }
    }

    public javax.jms.Topic getTopic(String topicName) throws JMSProviderException {
        Topic topic;
        try {
            topic = Topic.create((String)topicName);
            topic.setFreeReading();
            topic.setFreeWriting();
            this.createdDestinations.put(topicName, (Destination)topic);
        }
        catch (Exception e) {
            logger.error((Object)"Cannot create the topic with name {0}", new Object[]{topicName, e});
            throw new JMSProviderException("Cannot create the topic with name " + topicName, e);
        }
        return topic;
    }

    public void destroy() {
        for (Destination dest : this.createdDestinations.values()) {
            try {
                dest.delete();
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to delete the destination with name " + dest.getAdminName()), new Object[]{e});
            }
        }
        this.createdDestinations.clear();
        if (this.joramServer != null) {
            try {
                this.joramServer.stop();
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to stop the JORAM collocated server", new Object[]{e});
            }
        }
    }

    public Queue getQueue(String queueName) throws JMSProviderException {
        org.objectweb.joram.client.jms.Queue queue;
        try {
            queue = org.objectweb.joram.client.jms.Queue.create((String)queueName);
            queue.setFreeReading();
            queue.setFreeWriting();
            this.createdDestinations.put(queueName, (Destination)queue);
        }
        catch (Exception e) {
            logger.error((Object)"Cannot create the queue with name {0}", new Object[]{queueName, e});
            throw new JMSProviderException("Cannot create the queue with name " + queueName, e);
        }
        return queue;
    }

    public ConnectionFactory getQueueConnectionFactory() throws JMSProviderException {
        if (this.contextFactory.isEmbedded()) {
            return LocalConnectionFactory.create();
        }
        try {
            return TcpConnectionFactory.create();
        }
        catch (ConnectException e) {
            logger.error((Object)"Unable to create a queue connection factory", new Object[]{e});
            throw new JMSProviderException("Unable to create a queue connection factory", e);
        }
    }

    public void deleteQueue(String queueName) throws JMSProviderException {
        if (this.createdDestinations.containsKey(queueName)) {
            try {
                this.createdDestinations.remove(queueName).delete();
            }
            catch (Exception e) {
                logger.error((Object)("Unable to remove the queue with name " + queueName), new Object[]{e});
                throw new JMSProviderException("Unable to remove the queue with name " + queueName, e);
            }
        }
    }

    public void deleteTopic(String topicName) throws JMSProviderException {
        if (this.createdDestinations.containsKey(topicName)) {
            try {
                this.createdDestinations.remove(topicName).delete();
            }
            catch (Exception e) {
                logger.error((Object)("Unable to remove the topic with name " + topicName), new Object[]{e});
                throw new JMSProviderException("Unable to remove the topic with name " + topicName, e);
            }
        }
    }
}

