/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.remote.provider.joram;

import fr.dyade.aaa.agent.AgentServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.jms.ConnectionFactory;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.User;
import org.objectweb.joram.client.jms.tcp.TcpConnectionFactory;

public final class JORAMServer {
    private static Log logger = LogFactory.getLog(JORAMServer.class);
    private final short id;
    private final String hostname;
    private final int port;
    private final String topicConnectionFactoryName;
    private final String queueConnectionFactoryName;

    public JORAMServer() {
        this(0, "localhost", 16010, "JTCF", "JQCF");
    }

    public JORAMServer(short id, String hostname, int port, String topicConnectionFactoryName, String queueConnectionFactoryName) {
        this.id = id;
        this.hostname = hostname;
        this.port = port;
        this.topicConnectionFactoryName = topicConnectionFactoryName;
        this.queueConnectionFactoryName = queueConnectionFactoryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        String[] args = new String[]{Short.toString(this.id), "./s" + this.id};
        AgentServer.main((String[])args);
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("joramAdmin.xml");
        if (is != null) {
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader(is);
                AdminModule.executeAdmin((Reader)reader);
            }
            finally {
                try {
                    if (reader != null) {
                        ((Reader)reader).close();
                    }
                }
                catch (IOException e) {
                    logger.warn((Object)"Unable to close the reader of joramAdmin.xml", (Throwable)e);
                }
            }
        }
        AdminModule.collocatedConnect((String)"root", (String)"root");
        ConnectionFactory topicConnectionFactory = TcpConnectionFactory.create((String)this.hostname, (int)this.port);
        ConnectionFactory queueConnectionFactory = TcpConnectionFactory.create((String)this.hostname, (int)this.port);
        InitialContext context = new InitialContext();
        context.rebind(this.topicConnectionFactoryName, (Object)topicConnectionFactory);
        context.rebind(this.queueConnectionFactoryName, (Object)queueConnectionFactory);
        context.close();
        User.create((String)"anonymous", (String)"anonymous");
    }

    public void stop() throws Exception {
        InitialContext context = new InitialContext();
        context.unbind(this.topicConnectionFactoryName);
        context.unbind(this.queueConnectionFactoryName);
        context.close();
        AgentServer.stop();
    }

    public static void main(String[] args) throws Exception {
        JORAMServer server = new JORAMServer();
        server.start();
    }
}

