/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.sensors;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import org.ow2.wildcat.hierarchy.attribute.POJOAttribute;
import org.ow2.wildcat.sensors.Sensor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextFileSensor
extends POJOAttribute
implements Sensor {
    private static final long serialVersionUID = -6488447539127928360L;
    protected String filename;

    protected TextFileSensor(String filename) {
        super(null);
        this.filename = filename;
    }

    protected abstract Map<String, Object> getValues(String[] var1);

    @Override
    public Object getValue() {
        return this.getValues(this.getLines());
    }

    @Override
    public Object setValue(Object value) {
        return this.getValue();
    }

    protected String[] getLines() {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            BufferedReader reader = null;
            try {
                reader = new LineNumberReader(new FileReader(this.filename));
                String line = null;
                while ((line = ((LineNumberReader)reader).readLine()) != null) {
                    lines.add(line);
                }
            }
            catch (FileNotFoundException e) {
                throw new IOException("Unable to open " + this.filename + " file: " + e.getMessage());
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            lines.clear();
        }
        return lines.toArray(new String[lines.size()]);
    }

    protected static final class LineFormat {
        private Format format;
        private String property;

        public LineFormat(String property, String format) {
            this(property, new MessageFormat(format));
        }

        public LineFormat(String property, Format format) {
            this.property = property;
            this.format = format;
        }

        public Format getFormat() {
            return this.format;
        }

        public String getProperty() {
            return this.property;
        }
    }
}

