/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.examples.cluster;

import com.espertech.esper.client.UpdateListener;
import com.espertech.esper.event.EventBean;
import java.util.concurrent.TimeUnit;
import org.ow2.wildcat.Context;
import org.ow2.wildcat.ContextException;
import org.ow2.wildcat.ContextFactory;

public class Master {
    public static void main(String[] args) {
        ContextFactory contextFactory = new ContextFactory(Thread.currentThread().getContextClassLoader().getResource("wildcat-master.properties"));
        Context ctx = contextFactory.createContext();
        try {
            ctx.export();
        }
        catch (ContextException e1) {
            e1.printStackTrace();
        }
        ctx.registerListeners("select * from WEvent", new UpdateListener[]{new UpdateListener(){

            public void update(EventBean[] arg0, EventBean[] arg1) {
                for (EventBean bean : arg0) {
                    System.out.println("---> " + bean.getUnderlying().toString());
                }
            }
        }});
        while (!contextFactory.isRemoteContextAvailable("slave")) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        System.out.println("Slave is available!");
        try {
            ctx.createSymlink("self://slave", "slave://");
        }
        catch (ContextException e) {
            e.printStackTrace();
        }
        try {
            ctx.createAttribute("slave://proc/cpu#load", (Object)12);
            ctx.setValue("self://slave/proc/cpu#load", (Object)33);
            ctx.createPeriodicAttributePoller("slave://proc/cpu#load", 2L, TimeUnit.SECONDS);
        }
        catch (ContextException e) {
            e.printStackTrace();
        }
    }
}

