/**
 * WildCAT
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 EMN
 * Contact: wildcat@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: QueryAsAttribute.java 329 2008-09-03 14:01:07Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.wildcat.examples;

import java.util.concurrent.TimeUnit;

import net.esper.client.UpdateListener;
import net.esper.event.EventBean;

import org.ow2.wildcat.Context;
import org.ow2.wildcat.ContextException;
import org.ow2.wildcat.ContextFactory;
import org.ow2.wildcat.hierarchy.attribute.QueryAttribute;
import org.ow2.wildcat.sensors.CPULoadSensor;


/**
 * @author gsigms
 *
 */
public class QueryAsAttribute {

	/**
	 * @param args
	 */
	public static void main(final String[] args) {
		ContextFactory contextFactory = new ContextFactory();
		Context ctx = contextFactory.createContext();
		ctx.registerListeners("select * from WEvent", new UpdateListener() {
			public void update(final EventBean[] arg0, final EventBean[] arg1) {
				for (EventBean bean : arg0) {
					System.out.println(bean.getUnderlying());
				}
			}
		});

		try {
			ctx.attachAttribute("/proc/cpu#load", new CPULoadSensor());
			System.out.println("/proc/cpu#load = " + ctx.getValue("/proc/cpu#load"));
			ctx.createPeriodicAttributePoller("/proc/cpu#load", 2, TimeUnit.SECONDS);

			QueryAttribute qa = new QueryAttribute("select value('avg5')? from WEvent(source = \"self://proc/cpu#load\")");
			ctx.attachAttribute("/proc/cpu#avgload", qa);
		} catch (ContextException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
