/**
 *	This file is part of org.ow2.wildcat.
 *
 *	wildcat is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.
 *
 *	wildcat is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	authors:
 *		- Pierre-Charles David (initial)
 *		- Nicolas Loriant
 */
package org.ow2.wildcat.examples;

import net.esper.client.UpdateListener;
import net.esper.event.EventBean;

import org.ow2.wildcat.Context;
import org.ow2.wildcat.ContextException;
import org.ow2.wildcat.ContextFactory;
import org.ow2.wildcat.sensors.SensorLibrary;

/**
 * Example illustrating creating and attaching sensors
 */
public class Sensors {

	/**
	 * @param args unused
	 */
	public static void main(final String[] args) {
		Context ctx = ContextFactory.getDefaultFactory().createContext();
		ctx.registerListeners("select * from WEvent", new UpdateListener() {

			public void update(final EventBean[] arg0, final EventBean[] arg1) {
				for (EventBean bean : arg0) {
					System.out
					.println("... " + bean.getUnderlying().toString());
				}
			}

		});

		try {
			ctx.attachAttribute("self://sys#time", SensorLibrary.DEFAULT
					.instanciate("DateTime"));
			ctx.attachAttribute("self://sys#cpuload", SensorLibrary.DEFAULT
					.instanciate("CPULoad"));

			System.out.println("GET (self://sys#time) = "
					+ ctx.getValue("self://sys#time"));
			System.out.println("GET (self://sys#cpuload) = "
					+ ctx.getValue("self://sys#cpuload"));
		} catch (ContextException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
