/**
 *	This file is part of org.ow2.wildcat.
 *
 *	wildcat is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.
 *
 *	wildcat is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	authors:
 *		- Pierre-Charles David (initial)
 *		- Nicolas Loriant
 */
package org.ow2.wildcat.examples;

import net.esper.client.UpdateListener;
import net.esper.event.EventBean;

import org.ow2.wildcat.Context;
import org.ow2.wildcat.ContextException;
import org.ow2.wildcat.ContextFactory;

/**
 * A simple example demonstrating Symbolic links (aka softlink).
 */
public class Symlink {

	/**
	 * @param args
	 */
	public static void main(final String[] args) {
		Context ctx = ContextFactory.getDefaultFactory().createContext();
		ctx.registerListeners("select * from WEvent", new UpdateListener() {
			/*
			 * (non-Javadoc)
			 *
			 * @see net.esper.client.UpdateListener#update(net.esper.event.EventBean[],
			 *      net.esper.event.EventBean[])
			 */
			public void update(final EventBean[] arg0, final EventBean[] arg1) {
				for (EventBean bean : arg0) {
					System.out
					.println("--> " + bean.getUnderlying().toString());
				}
			}
		});

		try {
			ctx.createAttribute("self://strings#hello", "Hello");
			ctx.createSymlink("self://constants", "self://strings");
			System.out.println("self://constants#hello = "
					+ ctx.getValue("self://constants#hello"));
			System.out.println("SET (self://strings#hello, \"Hello World !\") = "
					+ ctx.setValue("self://strings#hello", "Hello World !"));
			System.out.println("GET (self://strings#hello) = "
					+ ctx.getValue("self://strings#hello"));
			System.out.println("GET (self://constants#hello) = "
					+ ctx.getValue("self://constants#hello"));
		} catch (ContextException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
