/**
 * WildCAT: A Generic Framework for Context-Aware Applications.
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 EMN
 * Contact: wildcat@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * --------------------------------------------------------------------------
 * $Id: StatAsAttribute.java 350 2008-11-10 09:41:14Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.wildcat.examples;

import net.esper.client.UpdateListener;
import net.esper.event.EventBean;

import org.ow2.wildcat.Context;
import org.ow2.wildcat.ContextFactory;
import org.ow2.wildcat.hierarchy.attribute.Attribute;
import org.ow2.wildcat.hierarchy.attribute.RunnableAttribute;

/**
 * Example of {@link RunnableAttribute}: WildStat filters and aggregates polled attributes from MBeans.
 * WildStat is defined in the JASMINe project (<a href="http://jasmine.ow2.org">http://jasmine.ow2.org</a>).
 * @author Loris Bouzonnet
 */
public class StatAsAttribute {

    private static Attribute attribute;

    /**
     * @param args
     */
    public static void main(final String[] args) throws Exception {
        ContextFactory contextFactory = new ContextFactory(
                Thread.currentThread().getContextClassLoader().getResource("standalone.properties"));
        Context ctx = contextFactory.createContext();
        ctx.registerListeners("select * from PathEvent", new UpdateListener() {

            public void update(final EventBean[] arg0, final EventBean[] arg1) {
                for(EventBean eventBean : arg0) {
                    System.out.println(">>>>>>>>>>>>>>>" + eventBean.getUnderlying());
                }
            }

        });

        Class<?> clazz = Class.forName("org.ow2.jasmine.monitoring.mbeancmd.commands.WildStat");

        attribute = (Attribute) clazz.getConstructor(String[].class).newInstance((Object) args);

        // Implicitly launch WildStat in a new thread
        ctx.attachAttribute("self://mb#stat", attribute);

    }

}
