/**
 * WildCAT: A Generic Framework for Context-Aware Applications.
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 EMN
 * Contact: wildcat@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * Authors:
 *		- Pierre-Charles David (initial)
 *		- Nicolas Loriant
 * --------------------------------------------------------------------------
 * $Id: ContextPull.java 385 2008-12-17 16:12:43Z barais $
 * --------------------------------------------------------------------------
 */
package org.ow2.wildcat.examples;



import org.ow2.wildcat.Context;
import org.ow2.wildcat.ContextException;
import org.ow2.wildcat.ContextFactory;

import com.espertech.esper.client.UpdateListener;
import com.espertech.esper.event.EventBean;

/**
 * Simple example usage of PULL mode operations on Context.
 */
public class ContextPull {

    /**
     * @param args
     *            unused
     */
    public static void main(final String[] args) {
        Context ctx = ContextFactory.getDefaultFactory().createContext();
        ctx.registerListeners("select * from WEvent", new UpdateListener() {

            public void update(final EventBean[] arg0, final EventBean[] arg1) {
                for (EventBean bean : arg0) {
                    System.out
                    .println("... " + bean.getUnderlying().toString());
                }
            }

        });
        System.out.println("NAME = " + ctx.getName());

        try {
            ctx.createAttribute("self://#_17", 0);
            ctx.createAttribute("self://messages#hello", "Hello");
            ctx.createSymlink("self://strings", "self://messages");

            System.out.println("LIST (self://) = " + ctx.list("self://"));
            System.out.println("LIST (self://messages) = "
                    + ctx.list("self://messages"));
            System.out.println("LIST (self://strings) = "
                    + ctx.list("self://strings"));
            System.out.println();
            System.out
            .println("GET (self://#_17) = " + ctx.getValue("self://#_17"));
            System.out.println("GET (self://messages#hello) = "
                    + ctx.getValue("self://messages#hello"));
            System.out.println("GET (self://strings#hello) = "
                    + ctx.getValue("self://strings#hello"));
            System.out.println();
            System.out.println("SET (self://#_17, 17) = "
                    + ctx.setValue("self://#_17", 17));
            System.out.println("SET (self://messages#hello, \"Hello World !\") = "
                    + ctx.setValue("self://messages#hello", "Hello World !"));
            System.out.println("SET (self://strings#hello, \"Hello World !\") = "
                    + ctx.setValue("self://strings#hello", "Hello World !"));
            System.out.println();
            System.out
            .println("GET (self://#_17) = " + ctx.getValue("self://#_17"));
            System.out.println("GET (self://messages#hello) = "
                    + ctx.getValue("self://messages#hello"));
            System.out.println("GET (self://stringss#hello) = "
                    + ctx.getValue("self://strings#hello"));
        } catch (ContextException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
}
