/**
 * WildCAT: A Generic Framework for Context-Aware Applications.
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 EMN
 * Contact: wildcat@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * Authors:
 *		- Pierre-Charles David (initial)
 *		- Nicolas Loriant
 * --------------------------------------------------------------------------
 * $Id: PeriodicAttributePoller.java 385 2008-12-17 16:12:43Z barais $
 * --------------------------------------------------------------------------
 */
package org.ow2.wildcat.examples;

import java.util.concurrent.TimeUnit;

import org.ow2.wildcat.ContextException;
import org.ow2.wildcat.ContextFactory;

import com.espertech.esper.client.UpdateListener;
import com.espertech.esper.event.EventBean;

/**
 * Simple example demonstrating periodic attribute polling.
 */
public class PeriodicAttributePoller {

    /**
     * @param args
     */
    public static void main(final String[] args) {
        org.ow2.wildcat.Context ctx = ContextFactory.getDefaultFactory().createContext();
        ctx.registerListeners("select * from WEvent", new UpdateListener() {
            /*
             * (non-Javadoc)
             *
             * @see net.esper.client.UpdateListener#update(net.esper.event.EventBean[],
             *      net.esper.event.EventBean[])
             */
            public void update(final EventBean[] arg0, final EventBean[] arg1) {
                for (EventBean bean : arg0) {
                    System.out
                    .println("--> " + bean.getUnderlying().toString());
                }
            }
        });

        try {
            ctx.createAttribute("self://strings#hello", "Hello");
            ctx.createPeriodicAttributePoller("self://strings#hello", 2,
                    TimeUnit.SECONDS);
        } catch (ContextException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

}
