/**
 * WildCAT: A Generic Framework for Context-Aware Applications.
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008 EMN
 * Contact: wildcat@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * --------------------------------------------------------------------------
 * $Id: QueryAsAttribute.java 405 2009-01-09 09:56:44Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.wildcat.examples;

import java.util.concurrent.TimeUnit;

import org.ow2.wildcat.Context;
import org.ow2.wildcat.ContextException;
import org.ow2.wildcat.ContextFactory;
import org.ow2.wildcat.hierarchy.attribute.QueryAttribute;
import org.ow2.wildcat.sensors.CPULoadSensor;

import com.espertech.esper.client.UpdateListener;
import com.espertech.esper.event.EventBean;


/**
 * @author Nicolas Loriant
 */
public class QueryAsAttribute {

    /**
     * @param args
     */
    public static void main(final String[] args) {
        ContextFactory contextFactory = new ContextFactory();
        Context ctx = contextFactory.createContext();
        ctx.registerListeners("select * from WEvent", new UpdateListener() {
            public void update(final EventBean[] arg0, final EventBean[] arg1) {
                for (EventBean bean : arg0) {
                    System.out.println(bean.getUnderlying());
                }
            }
        });

        try {
            ctx.attachAttribute("/proc/cpu#load", new CPULoadSensor());
            System.out.println("/proc/cpu#load = " + ctx.getValue("/proc/cpu#load"));
            ctx.createPeriodicAttributePoller("/proc/cpu#load", 2, TimeUnit.SECONDS);

            QueryAttribute qa = new QueryAttribute(
                    "select avg(cast(value('avg5')?,int)) from WEvent(source = \"self://proc/cpu#load\").win:time_batch(5 sec)");
            ctx.attachAttribute("/proc/cpu#avgload", qa);
        } catch (ContextException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

}
