/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.token.service;

import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.owasp.csrfguard.CsrfGuard;
import org.owasp.csrfguard.CsrfGuardException;
import org.owasp.csrfguard.CsrfValidator;
import org.owasp.csrfguard.ProtectionResult;
import org.owasp.csrfguard.session.LogicalSession;
import org.owasp.csrfguard.token.TokenUtils;
import org.owasp.csrfguard.token.businessobject.TokenBO;
import org.owasp.csrfguard.token.mapper.TokenMapper;
import org.owasp.csrfguard.token.storage.Token;
import org.owasp.csrfguard.token.storage.TokenHolder;
import org.owasp.csrfguard.token.storage.impl.PageTokenValue;
import org.owasp.csrfguard.token.transferobject.TokenTO;
import org.owasp.csrfguard.util.CsrfGuardUtils;

public class TokenService {
    private final CsrfGuard csrfGuard;

    public TokenService(CsrfGuard csrfGuard) {
        this.csrfGuard = csrfGuard;
    }

    public void invalidate(LogicalSession logicalSession) {
        String logicalSessionKey = logicalSession.getKey();
        TokenHolder tokenHolder = this.csrfGuard.getTokenHolder();
        tokenHolder.remove(logicalSessionKey);
        logicalSession.invalidate();
    }

    public String getMasterToken(String logicalSessionKey) {
        TokenHolder tokenHolder = this.csrfGuard.getTokenHolder();
        return this.getMasterToken(tokenHolder, logicalSessionKey);
    }

    public Map<String, String> getPageTokens(String logicalSessionKey) {
        TokenHolder tokenHolder = this.csrfGuard.getTokenHolder();
        return new HashMap<String, String>(tokenHolder.getPageTokens(logicalSessionKey));
    }

    public String generateTokensIfAbsent(String logicalSessionKey, String httpMethod, String requestURI) {
        ProtectionResult protectionResult;
        TokenHolder tokenHolder = this.csrfGuard.getTokenHolder();
        if (this.csrfGuard.isTokenPerPageEnabled() && (protectionResult = new CsrfValidator().isProtectedPageAndMethod(requestURI, httpMethod)).isProtected()) {
            return tokenHolder.createPageTokenIfAbsent(logicalSessionKey, protectionResult.getResourceIdentifier(), TokenUtils::generateRandomToken);
        }
        return tokenHolder.createMasterTokenIfAbsent(logicalSessionKey, TokenUtils::generateRandomToken);
    }

    public void createMasterTokenIfAbsent(String logicalSessionKey) {
        TokenHolder tokenHolder = this.csrfGuard.getTokenHolder();
        tokenHolder.createMasterTokenIfAbsent(logicalSessionKey, TokenUtils::generateRandomToken);
    }

    public void generateProtectedPageTokens(String logicalSessionKey) {
        HashMap generatedPageTokens = this.csrfGuard.getProtectedPages().stream().collect(Collectors.toMap(Function.identity(), k -> TokenUtils.generateRandomToken(), (a, b) -> b, HashMap::new));
        TokenHolder tokenHolder = this.csrfGuard.getTokenHolder();
        tokenHolder.createMasterTokenIfAbsent(logicalSessionKey, TokenUtils::generateRandomToken);
        tokenHolder.setPageTokens(logicalSessionKey, generatedPageTokens);
    }

    public TokenTO rotateUsedToken(String logicalSessionKey, String requestURI, TokenBO usedValidToken) {
        TokenHolder tokenHolder = this.csrfGuard.getTokenHolder();
        String newTokenValue = TokenUtils.generateRandomToken();
        if (usedValidToken.isUsedMasterToken()) {
            tokenHolder.setMasterToken(logicalSessionKey, newTokenValue);
            usedValidToken.setUpdatedMasterToken(newTokenValue);
        } else {
            tokenHolder.setPageToken(logicalSessionKey, requestURI, newTokenValue);
            usedValidToken.setUpdatedPageToken(requestURI, newTokenValue);
        }
        return TokenMapper.toTransferObject(usedValidToken);
    }

    public void rotateAllTokens(String logicalSessionKey) {
        TokenHolder tokenHolder = this.csrfGuard.getTokenHolder();
        tokenHolder.setMasterToken(logicalSessionKey, TokenUtils.generateRandomToken());
        tokenHolder.rotateAllPageTokens(logicalSessionKey, TokenUtils::generateRandomToken);
    }

    public String getTokenValue(String logicalSessionKey, String resourceUri) {
        TokenHolder tokenHolder = this.csrfGuard.getTokenHolder();
        return this.csrfGuard.isTokenPerPageEnabled() ? tokenHolder.createPageTokenIfAbsent(logicalSessionKey, resourceUri, TokenUtils::generateRandomToken) : tokenHolder.createMasterTokenIfAbsent(logicalSessionKey, TokenUtils::generateRandomToken);
    }

    public TokenBO verifyToken(HttpServletRequest request, String resourceIdentifier, String logicalSessionKey, String masterToken) throws CsrfGuardException {
        String tokenFromRequest;
        String tokenName = this.csrfGuard.getTokenName();
        boolean isAjaxRequest = this.csrfGuard.isAjaxEnabled() && CsrfGuardUtils.isAjaxRequest(request);
        String string = tokenFromRequest = isAjaxRequest ? request.getHeader(tokenName) : request.getParameter(tokenName);
        if (Objects.isNull(tokenFromRequest)) {
            throw new CsrfGuardException("Required Token is missing from the Request");
        }
        TokenBO tokenBO = this.csrfGuard.isTokenPerPageEnabled() ? this.verifyPageToken(logicalSessionKey, masterToken, tokenFromRequest, resourceIdentifier, isAjaxRequest) : this.verifyMasterToken(masterToken, tokenFromRequest);
        return tokenBO;
    }

    private String getMasterToken(TokenHolder tokenHolder, String tokenKey) {
        Token token = tokenHolder.getToken(tokenKey);
        return Objects.nonNull(token) ? token.getMasterToken() : null;
    }

    private TokenBO verifyPageToken(String logicalSessionKey, String masterToken, String tokenFromRequest, String requestURI, boolean isAjaxRequest) throws CsrfGuardException {
        TokenBO tokenBO;
        TokenHolder tokenHolder = this.csrfGuard.getTokenHolder();
        Token token = tokenHolder.getToken(logicalSessionKey);
        PageTokenValue timedPageToken = token.getTimedPageToken(requestURI);
        if (timedPageToken == null) {
            String newPageToken = TokenUtils.generateRandomToken();
            tokenHolder.setPageToken(logicalSessionKey, requestURI, newPageToken);
            tokenBO = this.verifyMasterToken(masterToken, tokenFromRequest).setUpdatedPageToken(requestURI, newPageToken);
        } else {
            String pageToken = timedPageToken.getValue();
            if (pageToken.equals(tokenFromRequest)) {
                tokenBO = new TokenBO().setUsedPageToken(tokenFromRequest);
            } else if (this.initIsWithinTimeTolerance(this.csrfGuard, isAjaxRequest, timedPageToken)) {
                tokenBO = this.verifyMasterToken(masterToken, tokenFromRequest).setUpdatedPageToken(requestURI, pageToken);
            } else {
                if (masterToken.equals(pageToken)) {
                    tokenHolder.setMasterToken(logicalSessionKey, TokenUtils.generateRandomToken());
                }
                tokenHolder.regenerateUsedPageToken(logicalSessionKey, tokenFromRequest, TokenUtils::generateRandomToken);
                throw new CsrfGuardException("Request Token does not match Page Token");
            }
        }
        return tokenBO;
    }

    private boolean initIsWithinTimeTolerance(CsrfGuard csrfGuard, boolean isAjaxRequest, PageTokenValue tokenTimedPageToken) {
        return isAjaxRequest && !csrfGuard.isTokenPerPagePrecreate() && tokenTimedPageToken.getCreationTime().plus(this.csrfGuard.getPageTokenSynchronizationTolerance()).isAfter(LocalDateTime.now());
    }

    private TokenBO verifyMasterToken(String storedToken, String tokenFromRequest) throws CsrfGuardException {
        if (storedToken.equals(tokenFromRequest)) {
            return new TokenBO().setUsedMasterToken(tokenFromRequest);
        }
        throw new CsrfGuardException("Request Token does not match the Master Token");
    }
}

