/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.token.storage.impl;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import org.owasp.csrfguard.token.storage.Token;
import org.owasp.csrfguard.token.storage.TokenHolder;
import org.owasp.csrfguard.token.storage.impl.InMemoryToken;

public class InMemoryTokenHolder
implements TokenHolder {
    private static final Map<String, Token> TOKENS = new ConcurrentHashMap<String, Token>();

    @Override
    public void setMasterToken(String sessionKey, String value) {
        TOKENS.compute(sessionKey, (k, v) -> {
            Token result;
            if (Objects.isNull(v)) {
                result = new InMemoryToken(value);
            } else {
                v.setMasterToken(value);
                result = v;
            }
            return result;
        });
    }

    @Override
    public String createMasterTokenIfAbsent(String sessionKey, Supplier<String> valueSupplier) {
        Token token = TOKENS.computeIfAbsent(sessionKey, k -> new InMemoryToken((String)valueSupplier.get()));
        return token.getMasterToken();
    }

    @Override
    public String createPageTokenIfAbsent(String sessionKey, String resourceUri, Supplier<String> valueSupplier) {
        Token token = TOKENS.get(sessionKey);
        if (Objects.isNull(token)) {
            String newPageToken = valueSupplier.get();
            TOKENS.computeIfAbsent(sessionKey, k -> new InMemoryToken((String)valueSupplier.get(), (Pair<String, String>)Pair.of((Object)resourceUri, (Object)newPageToken)));
            return newPageToken;
        }
        return token.setPageTokenIfAbsent(resourceUri, valueSupplier);
    }

    @Override
    public Token getToken(String sessionKey) {
        return TOKENS.get(sessionKey);
    }

    @Override
    public String getPageToken(String sessionKey, String resourceUri) {
        Token token = TOKENS.get(sessionKey);
        return Objects.nonNull(token) ? token.getPageToken(resourceUri) : null;
    }

    @Override
    public void setPageToken(String sessionKey, String resourceUri, String value) {
        this.getTokenOrException(sessionKey).setPageToken(resourceUri, value);
    }

    @Override
    public void setPageTokens(String sessionKey, Map<String, String> pageTokens) {
        this.getTokenOrException(sessionKey).setPageTokens(pageTokens);
    }

    @Override
    public Map<String, String> getPageTokens(String sessionKey) {
        return this.getTokenOrException(sessionKey).getPageTokens();
    }

    @Override
    public void remove(String sessionKey) {
        TOKENS.remove(sessionKey);
    }

    @Override
    public void rotateAllPageTokens(String sessionKey, Supplier<String> tokenValueSupplier) {
        Token token = this.getTokenOrException(sessionKey);
        token.rotateAllPageTokens(tokenValueSupplier);
    }

    @Override
    public void regenerateUsedPageToken(String sessionKey, String tokenFromRequest, Supplier<String> tokenValueSupplier) {
        Token token = this.getTokenOrException(sessionKey);
        token.regenerateUsedPageToken(tokenFromRequest, tokenValueSupplier);
    }

    private Token getTokenOrException(String sessionKey) {
        Token token = TOKENS.get(sessionKey);
        if (Objects.isNull(token)) {
            throw new IllegalStateException("Token with the provided session key does not exist!");
        }
        return token;
    }
}

