/***************************************************************************************************
 * 
 * 
 * This file is part of WebGoat, an Open Web Application Security Project utility. For details,
 * please see http://www.owasp.org/
 * 
 * Copyright (c) 2002 - 20014 Bruce Mayhew
 * 
 * This program is free software; you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with this program; if
 * not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 * 
 * Getting Source ==============
 * 
 * Source for this application is maintained at https://github.com/WebGoat/WebGoat, a repository for free software
 * projects.
 * 
 */
package org.owasp.webgoat.lessons.model;

/**
 * Model component for the Http Basics lesson.  Using a model
 * for that simple lesson is architectural overkill.  We do it anyway
 * for illustrative purposes - to demonstrate the pattern that we will
 * use for more complex lessons.
 *
 * @version $Id: $Id
 * @author dm
 */
public class HttpBasicsModel {

    private String personName;

    /**
     * <p>Getter for the field <code>personName</code>.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getPersonName() {
        return personName;
    }

    /**
     * <p>Setter for the field <code>personName</code>.</p>
     *
     * @param personName a {@link java.lang.String} object.
     */
    public void setPersonName(String personName) {
        this.personName = personName;
    }
}
