/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat;

import com.github.ryenus.rop.OptionParser;
import java.io.File;
import java.net.InetAddress;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.AbstractProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OptionParser.Command(name="webgoat", descriptions={"Starting WebGoat"})
public class Main {
    private final Logger logger = LoggerFactory.getLogger(Main.class);
    @OptionParser.Option(opt={"-p", "--port"}, description="HTTP port to use")
    int port = 6047;
    @OptionParser.Option(opt={"-a", "--address"}, description="Server address to use")
    String address = "localhost";

    void run() throws Exception {
        String webappDirLocation = "webgoat-container/src/main/webapp/";
        Tomcat tomcat = new Tomcat();
        StandardContext ctx = (StandardContext)tomcat.addWebapp("/WebGoat", new File(webappDirLocation).getAbsolutePath());
        Connector connector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
        connector.setPort(this.port);
        if (connector.getProtocolHandler() instanceof AbstractProtocol) {
            AbstractProtocol protocol = (AbstractProtocol)connector.getProtocolHandler();
            protocol.setAddress(InetAddress.getByName(this.address));
            protocol.setPort(this.port);
        }
        tomcat.getService().addConnector(connector);
        tomcat.start();
        this.logger.info("Browse to http://{}:{}/WebGoat and happy hacking!", (Object)this.address, (Object)this.port);
        tomcat.getServer().await();
    }

    public static void main(String[] args) throws Exception {
        OptionParser parser = new OptionParser(new Object[]{Main.class});
        parser.parse(args);
    }
}

