/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.commons.user.domain;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlTransient;
import org.oxerr.commons.user.domain.BaseEntity;
import org.oxerr.commons.user.domain.Role;

@Entity
@Access(value=AccessType.PROPERTY)
@Table(name="\"user\"", uniqueConstraints={@UniqueConstraint(name="uk_user_username", columnNames={"username"})})
public class User
extends BaseEntity {
    private static final long serialVersionUID = 2019062401L;
    private String username;
    private String password;
    private String nickname;
    private Set<Role> roles;
    private boolean enabled;

    public User() {
    }

    public User(String username, String password, String nickname, Set<Role> roles, boolean enabled) {
        this.username = username;
        this.password = password;
        this.nickname = nickname;
        this.roles = roles;
        this.enabled = enabled;
    }

    @Column(name="username")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @XmlTransient
    @Column(name="password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Column(name="nickname")
    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    @XmlTransient
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="\"authorities\"", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="role_id")}, foreignKey=@ForeignKey(name="fk_authorities_user"), inverseForeignKey=@ForeignKey(name="fk_authorities_role"))
    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    @XmlTransient
    @Transient
    private Set<Role> getOrCreateRoles() {
        Set<Role> exists = this.getRoles();
        if (exists == null) {
            exists = new HashSet<Role>();
            this.setRoles(exists);
        }
        return exists;
    }

    @XmlTransient
    @Transient
    public void addRoles(Set<Role> roles) {
        if (roles == null || roles.isEmpty()) {
            return;
        }
        Set<Role> exists = this.getOrCreateRoles();
        try {
            exists.addAll(roles);
        }
        catch (UnsupportedOperationException e) {
            HashSet<Role> ret = new HashSet<Role>();
            ret.addAll(exists);
            ret.addAll(roles);
            this.setRoles(ret);
        }
    }

    @XmlTransient
    @Transient
    public void addRole(Role role) {
        if (role == null) {
            return;
        }
        Set<Role> exists = this.getOrCreateRoles();
        try {
            exists.add(role);
        }
        catch (UnsupportedOperationException e) {
            HashSet<Role> ret = new HashSet<Role>();
            ret.addAll(exists);
            ret.add(role);
            this.setRoles(ret);
        }
    }

    @XmlTransient
    @Transient
    public boolean hasAnyAuthority(String ... authorities) {
        return this.getRoles().stream().map(role -> role.getName()).anyMatch(Arrays.asList(authorities)::contains);
    }

    @Column(nullable=false)
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

