/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.commons.user.service.impl;

import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import java.util.Optional;
import org.oxerr.commons.user.domain.Email;
import org.oxerr.commons.user.domain.QEmail;
import org.oxerr.commons.user.repository.EmailRepository;
import org.oxerr.commons.user.service.EmailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class EmailServiceImpl
implements EmailService {
    private final QEmail qEmail = QEmail.email;
    private final EmailRepository emailRepository;

    @Autowired
    public EmailServiceImpl(EmailRepository emailRepository) {
        this.emailRepository = emailRepository;
    }

    public Email saveEmail(Email email) {
        return (Email)this.emailRepository.save((Object)email);
    }

    public Optional<Email> getEmailByAddress(String address) {
        return this.emailRepository.findByAddress(address);
    }

    public Page<Email> getEmails(String address, String username, Pageable pageable) {
        Predicate predicate = ExpressionUtils.allOf((Predicate[])new Predicate[]{address != null ? this.qEmail.address.eq((Object)address) : null, username != null ? this.qEmail.user.username.eq((Object)username) : null});
        return this.emailRepository.findAll(predicate, pageable);
    }
}

