/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.commons.user.service.impl;

import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import java.util.Optional;
import org.oxerr.commons.user.domain.Phone;
import org.oxerr.commons.user.domain.QPhone;
import org.oxerr.commons.user.repository.PhoneRepository;
import org.oxerr.commons.user.service.PhoneService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class PhoneServiceImpl
implements PhoneService {
    private final QPhone qPhone = QPhone.phone;
    private final PhoneRepository phoneRepository;

    @Autowired
    public PhoneServiceImpl(PhoneRepository phoneRepository) {
        this.phoneRepository = phoneRepository;
    }

    public Phone savePhone(Phone phone) {
        return (Phone)this.phoneRepository.save((Object)phone);
    }

    public Optional<Phone> getPhoneByNumber(String number) {
        return this.phoneRepository.findByNumber(number);
    }

    public Page<Phone> getPhones(String number, String username, Pageable pageable) {
        Predicate predicate = ExpressionUtils.allOf((Predicate[])new Predicate[]{number != null ? this.qPhone.number.eq((Object)number) : null, username != null ? this.qPhone.user.username.eq((Object)username) : null});
        return this.phoneRepository.findAll(predicate, pageable);
    }
}

