/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.commons.user.service.impl;

import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.oxerr.commons.user.domain.QRole;
import org.oxerr.commons.user.domain.Role;
import org.oxerr.commons.user.repository.RoleRepository;
import org.oxerr.commons.user.service.RoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class RoleServiceImpl
implements RoleService {
    private final QRole qRole = QRole.role;
    private final RoleRepository roleRepository;

    @Autowired
    public RoleServiceImpl(RoleRepository roleRepository) {
        this.roleRepository = roleRepository;
    }

    public Role saveRole(Role role) {
        return (Role)this.roleRepository.save((Object)role);
    }

    public Optional<Role> getRole(UUID id) {
        return this.roleRepository.findById((Object)id);
    }

    public Optional<Role> getRoleByName(String name) {
        return this.roleRepository.findByName(name);
    }

    public Page<Role> getRoles(String name, Pageable pageable) {
        Predicate predicate = ExpressionUtils.allOf((Predicate[])new Predicate[]{name != null ? this.qRole.name.eq((Object)name) : null});
        return this.roleRepository.findAll(predicate, pageable);
    }

    @PostConstruct
    private void init() {
        this.getRoleByName("ROLE_ADMIN").orElseGet(() -> this.saveRole(new Role("ROLE_ADMIN")));
        this.getRoleByName("ROLE_USER").orElseGet(() -> this.saveRole(new Role("ROLE_USER")));
    }
}

