/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.commons.user.service.impl;

import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.oxerr.commons.user.domain.QRole;
import org.oxerr.commons.user.domain.QUser;
import org.oxerr.commons.user.domain.User;
import org.oxerr.commons.user.repository.UserRepository;
import org.oxerr.commons.user.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
implements UserService {
    private final QUser qUser = QUser.user;
    private final UserRepository userRepository;

    @Autowired
    public UserServiceImpl(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public User saveUser(User user) {
        return (User)this.userRepository.save((Object)user);
    }

    public Optional<User> getUser(UUID id) {
        return this.userRepository.findById((Object)id);
    }

    public Optional<User> getUserByUsername(String username) {
        return this.userRepository.findByUsername(username);
    }

    public Page<User> getUsers(String username, Boolean enabled, UUID[] roleIds, Pageable pageable) {
        Predicate predicate = ExpressionUtils.allOf((Predicate[])new Predicate[]{username != null ? this.qUser.username.eq((Object)username) : null, enabled != null ? this.qUser.enabled.eq(enabled) : null, ArrayUtils.isNotEmpty((Object[])roleIds) ? ((QRole)this.qUser.roles.any()).id.in((Object[])roleIds) : null});
        return this.userRepository.findAll(predicate, pageable);
    }
}

