/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.huobi.fix;

import java.math.BigDecimal;
import org.oxerr.huobi.fix.HuobiApplication;
import org.oxerr.huobi.fix.TradeRequests;
import org.oxerr.huobi.fix.fix44.AccountInfoRequest;
import org.oxerr.huobi.fix.fix44.AccountInfoResponse;
import org.oxerr.huobi.fix.fix44.HuobiOrderInfoResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.FieldNotFound;
import quickfix.IncorrectDataFormat;
import quickfix.IncorrectTagValue;
import quickfix.Message;
import quickfix.SessionID;
import quickfix.StringField;
import quickfix.UnsupportedMessageType;
import quickfix.field.MsgType;
import quickfix.field.Password;
import quickfix.field.Username;
import quickfix.fix44.ExecutionReport;
import quickfix.fix44.NewOrderSingle;
import quickfix.fix44.OrderCancelReject;
import quickfix.fix44.OrderCancelRequest;
import quickfix.fix44.OrderMassStatusRequest;
import quickfix.fix44.OrderStatusRequest;

public class TradeApplication
extends HuobiApplication {
    private final Logger log = LoggerFactory.getLogger(TradeApplication.class);
    private final String accessKey;
    private final String secretKey;

    public TradeApplication(String accessKey, String secretKey) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    @Override
    public void toAdmin(Message message, SessionID sessionId) {
        String msgType;
        super.toAdmin(message, sessionId);
        try {
            msgType = message.getHeader().getString(35);
        }
        catch (FieldNotFound e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if ("A".equals(msgType)) {
            message.setField((StringField)new Username(this.accessKey));
            message.setField((StringField)new Password(this.secretKey));
        }
    }

    @Override
    public void fromApp(Message message, SessionID sessionId) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType {
        this.log.trace("fromApp: {}", (Object)message);
        MsgType msgType = new MsgType();
        message.getHeader().getField((StringField)msgType);
        String msgTypeValue = msgType.getValue();
        if (msgTypeValue.equals("Z1001")) {
            this.onMessage((AccountInfoResponse)message, sessionId);
        } else if (msgTypeValue.equals("Z1003")) {
            this.onMessage((HuobiOrderInfoResponse)message, sessionId);
        } else {
            this.crack(message, sessionId);
        }
    }

    public void onMessage(AccountInfoResponse message, SessionID sessionId) throws FieldNotFound, UnsupportedMessageType, IncorrectTagValue {
    }

    public void onMessage(HuobiOrderInfoResponse message, SessionID sessionId) throws FieldNotFound, UnsupportedMessageType, IncorrectTagValue {
    }

    public void onMessage(ExecutionReport message, SessionID sessionId) throws FieldNotFound, UnsupportedMessageType, IncorrectTagValue {
    }

    public void onMessage(OrderCancelReject message, SessionID sessionId) throws FieldNotFound, UnsupportedMessageType, IncorrectTagValue {
    }

    public void requestAccountInfo(String accReqId, String symbol, SessionID sessionId) {
        AccountInfoRequest message = TradeRequests.buildAccountInfoRequest(accReqId, this.accessKey, symbol);
        this.sendMessage((Message)message, sessionId);
    }

    public void placeOrder(String clOrdId, char side, char ordType, BigDecimal minQty, BigDecimal price, String symbol, SessionID sessionId) {
        NewOrderSingle message = TradeRequests.buildNewOrderSingle(clOrdId, this.accessKey, side, ordType, minQty, price, symbol);
        this.sendMessage((Message)message, sessionId);
    }

    public void cancelOrder(String clOrdId, String origClOrdId, char side, String symbol, SessionID sessionId) {
        OrderCancelRequest message = TradeRequests.buildOrderCancelRequest(clOrdId, origClOrdId, side, symbol);
        this.sendMessage((Message)message, sessionId);
    }

    public void requestOrderMassStatus(String massStatusReqId, int massStatusReqType, String symbol, SessionID sessionId) {
        OrderMassStatusRequest message = TradeRequests.buildOrderMassStatusRequest(massStatusReqId, this.accessKey, massStatusReqType, symbol);
        this.sendMessage((Message)message, sessionId);
    }

    public void requestOrderStatus(String clOrdId, char side, String symbol, SessionID sessionId) {
        OrderStatusRequest message = TradeRequests.buildOrderStatusRequest(clOrdId, this.accessKey, side, symbol);
        this.sendMessage((Message)message, sessionId);
    }
}

