/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.huobi.rest;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicHeader;
import org.oxerr.huobi.rest.valuereader.JsonValueReader;
import org.oxerr.huobi.rest.valuereader.JsonValueTypeRefReader;
import org.oxerr.huobi.rest.valuereader.ValueReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient
implements AutoCloseable {
    public static final String REFERER_HEADER_NAME = "Referer";
    private static final int SC_OK = 200;
    private final Logger log = LoggerFactory.getLogger(HttpClient.class);
    private final CloseableHttpClient httpClient;
    private final ObjectMapper objectMapper;
    private HttpUriRequest lastRequest;
    private long interval = 0L;
    private long lastRequestTime;

    public HttpClient(int socketTimeout, int connectTimeout, int connectionRequestTimeout, long interval) {
        this(socketTimeout, connectTimeout, connectionRequestTimeout);
        this.interval = interval;
    }

    public HttpClient(int socketTimeout, int connectTimeout, int connectionRequestTimeout) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        String userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_5) AppleWebKit/537.71 (KHTML, like Gecko) Version/6.1 Safari/537.71";
        httpClientBuilder.setUserAgent(userAgent);
        ArrayList<BasicHeader> defaultHeaders = new ArrayList<BasicHeader>();
        defaultHeaders.add(new BasicHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8"));
        httpClientBuilder.setDefaultHeaders(defaultHeaders);
        RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(socketTimeout).setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectionRequestTimeout).setStaleConnectionCheckEnabled(true).build();
        httpClientBuilder.setDefaultRequestConfig(defaultRequestConfig);
        this.httpClient = httpClientBuilder.build();
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
    }

    public <T> T get(URI uri, Class<T> valueType) throws IOException {
        return this.get(uri, new JsonValueReader<T>(this.objectMapper, valueType));
    }

    public <T> T get(URI uri, TypeReference<T> valueTypeRef) throws IOException {
        return this.get(uri, new JsonValueTypeRefReader<T>(this.objectMapper, valueTypeRef));
    }

    public <T> T get(URI uri, ValueReader<T> valueReader) throws IOException {
        return this.execute(valueReader, (HttpUriRequest)new HttpGet(uri));
    }

    public <T> T post(URI uri, ValueReader<T> valueReader, NameValuePair ... params) throws IOException {
        return this.post(uri, valueReader, Arrays.asList(params));
    }

    public <T> T post(URI uri, ValueReader<T> valueReader, List<NameValuePair> params) throws IOException {
        HttpPost post = new HttpPost(uri);
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        return this.execute(valueReader, (HttpUriRequest)post);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T execute(ValueReader<T> valueReader, HttpUriRequest request) throws IOException {
        this.log.trace("Executing: {}", (Object)request);
        this.sleep();
        if (!request.containsHeader(REFERER_HEADER_NAME) && this.lastRequest != null) {
            String referer = this.lastRequest.getURI().toString();
            this.log.debug("Setting header Referer: {}", (Object)referer);
            request.setHeader(REFERER_HEADER_NAME, referer);
        }
        try {
            CloseableHttpResponse response = this.httpClient.execute(request);
            Throwable throwable = null;
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() != 200) throw new IOException(statusLine.getReasonPhrase());
            this.lastRequest = request;
            InputStream content = response.getEntity().getContent();
            Throwable throwable2 = null;
            T t = valueReader.read(content);
            return t;
            {
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (content != null) {
                        if (throwable2 != null) {
                            try {
                                content.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                        } else {
                            content.close();
                        }
                    }
                }
                {
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
            }
            finally {
                if (response != null) {
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        response.close();
                    }
                }
            }
        }
        finally {
            this.lastRequestTime = System.currentTimeMillis();
        }
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    private void sleep() {
        long millis = this.lastRequestTime + this.interval - System.currentTimeMillis();
        if (millis > 0L) {
            this.log.debug("Sleeping {} millis.", (Object)millis);
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

