/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.huobi.rest;

import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.Order;
import com.xeiam.xchange.dto.marketdata.OrderBook;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trade;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.dto.trade.Wallet;
import com.xeiam.xchange.exceptions.ExchangeException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.oxerr.huobi.rest.dto.account.AccountInfo;
import org.oxerr.huobi.rest.dto.marketdata.Depth;
import org.oxerr.huobi.rest.dto.marketdata.OrderBookTAS;
import org.oxerr.huobi.rest.dto.marketdata.Ticker;
import org.oxerr.huobi.rest.dto.marketdata.TickerObject;
import org.oxerr.huobi.rest.dto.marketdata.TradeObject;
import org.oxerr.huobi.rest.dto.trade.Order;
import org.oxerr.huobi.rest.dto.trade.PlaceOrderResult;

public final class HuobiAdapters {
    private HuobiAdapters() {
    }

    public static com.xeiam.xchange.dto.marketdata.Ticker adaptTicker(Ticker huobiTicker, CurrencyPair currencyPair) {
        TickerObject ticker = huobiTicker.getTicker();
        return new Ticker.Builder().currencyPair(currencyPair).last(ticker.getLast()).bid(ticker.getBuy()).ask(ticker.getSell()).high(ticker.getHigh()).low(ticker.getLow()).volume(ticker.getVol()).build();
    }

    public static OrderBook adaptOrderBook(Depth huobiDepth, CurrencyPair currencyPair) {
        List<LimitOrder> asks = HuobiAdapters.adaptOrderBook(huobiDepth.getAsks(), Order.OrderType.ASK, currencyPair);
        Collections.reverse(asks);
        List<LimitOrder> bids = HuobiAdapters.adaptOrderBook(huobiDepth.getBids(), Order.OrderType.BID, currencyPair);
        return new OrderBook(null, asks, bids);
    }

    private static List<LimitOrder> adaptOrderBook(BigDecimal[][] orders, Order.OrderType type, CurrencyPair currencyPair) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>(orders.length);
        for (BigDecimal[] order : orders) {
            LimitOrder limitOrder = new LimitOrder(type, order[1], currencyPair, null, null, order[0]);
            limitOrders.add(limitOrder);
        }
        return limitOrders;
    }

    public static Trades adaptTrades(OrderBookTAS huobiDetail, CurrencyPair currencyPair) {
        List<Trade> trades = HuobiAdapters.adaptTrades(huobiDetail.getTrades(), currencyPair);
        return new Trades(trades, Trades.TradeSortType.SortByTimestamp);
    }

    private static List<Trade> adaptTrades(TradeObject[] trades, CurrencyPair currencyPair) {
        ArrayList<Trade> tradeList = new ArrayList<Trade>(trades.length);
        for (TradeObject trade : trades) {
            tradeList.add(HuobiAdapters.adaptTrade(trade, currencyPair));
        }
        return tradeList;
    }

    private static Trade adaptTrade(TradeObject trade, CurrencyPair currencyPair) {
        Date time;
        Order.OrderType type = trade.getType().equals("\u4e70\u5165") ? Order.OrderType.BID : Order.OrderType.ASK;
        try {
            time = DateUtils.parseDate((String)trade.getTime(), (String[])new String[]{"HH:mm:ss"});
        }
        catch (ParseException e) {
            throw new ExchangeException(e.getMessage(), (Throwable)e);
        }
        return new Trade(type, trade.getAmount(), currencyPair, trade.getPrice(), time, null);
    }

    public static com.xeiam.xchange.dto.account.AccountInfo adaptAccountInfo(AccountInfo a) {
        Wallet cny = new Wallet("CNY", a.getAvailableCnyDisplay().add(a.getFrozenCnyDisplay()));
        Wallet btc = new Wallet("BTC", a.getAvailableBtcDisplay().add(a.getFrozenBtcDisplay()));
        Wallet ltc = new Wallet("LTC", a.getAvailableLtcDisplay().add(a.getFrozenLtcDisplay()));
        List<Wallet> wallets = Arrays.asList(cny, btc, ltc);
        return new com.xeiam.xchange.dto.account.AccountInfo(null, wallets);
    }

    public static String adaptPlaceOrderResult(PlaceOrderResult result) {
        if (result.getCode() == 0) {
            return String.valueOf(result.getId());
        }
        throw new ExchangeException(result.getMsg());
    }

    public static List<LimitOrder> adaptOpenOrders(Order[] orders, CurrencyPair currencyPair) {
        ArrayList<LimitOrder> openOrders = new ArrayList<LimitOrder>();
        for (Order order : orders) {
            openOrders.add(HuobiAdapters.adaptOpenOrder(order, currencyPair));
        }
        return openOrders;
    }

    private static LimitOrder adaptOpenOrder(Order order, CurrencyPair currencyPair) {
        return new LimitOrder(order.getType() == 1 ? Order.OrderType.BID : Order.OrderType.ASK, order.getOrderAmount().subtract(order.getProcessedAmount()), currencyPair, String.valueOf(order.getId()), new Date(order.getOrderTime() * 1000L), order.getOrderPrice());
    }
}

