/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.huobi.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.message.BasicNameValuePair;
import org.oxerr.huobi.rest.HttpClient;
import org.oxerr.huobi.rest.HuobiClientException;
import org.oxerr.huobi.rest.domain.Delegation;
import org.oxerr.huobi.rest.domain.Depth;
import org.oxerr.huobi.rest.domain.Funds;
import org.oxerr.huobi.rest.domain.LoginResult;
import org.oxerr.huobi.rest.domain.MyTradeInfo;
import org.oxerr.huobi.rest.domain.TradeResult;
import org.oxerr.huobi.rest.domain.Type;
import org.oxerr.huobi.rest.valuereader.DelegationReader;
import org.oxerr.huobi.rest.valuereader.JsonValueReader;
import org.oxerr.huobi.rest.valuereader.LoginResultReader;
import org.oxerr.huobi.rest.valuereader.VoidValueReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class HuobiClient
implements AutoCloseable {
    public static final String ENCODING = "UTF-8";
    private static final URI HTTPS_BASE = URI.create("https://www.huobi.com/");
    private static final URI LOGIN_URI = URIUtils.resolve((URI)HTTPS_BASE, (String)"account/login.php");
    private static final URI DEPTH_URI = URI.create("http://market.huobi.com/market/depth.php");
    private static final URI TRADE_URI = URIUtils.resolve((URI)HTTPS_BASE, (String)"trade/index.php");
    private static final URI ACCOUNT_AJAX_URI = URIUtils.resolve((URI)HTTPS_BASE, (String)"account/ajax.php");
    private static final URI CANCEL_REFERER_URI = URIUtils.resolve((URI)TRADE_URI, (String)"?a=delegation");
    private final Logger log = LoggerFactory.getLogger(HuobiClient.class);
    private final HttpClient httpClient;
    private final String email;
    private final String password;

    public HuobiClient(int socketTimeout, int connectTimeout, int connectionRequestTimeout) {
        this(null, null, socketTimeout, connectTimeout, connectionRequestTimeout);
    }

    public HuobiClient(String email, String password, int socketTimeout, int connectTimeout, int connectionRequestTimeout) {
        this.httpClient = new HttpClient(socketTimeout, connectTimeout, connectionRequestTimeout, 1000L);
        this.email = email;
        this.password = password;
    }

    public void login() throws IOException {
        this.initLoginPage();
        LoginResult loginResult = this.httpClient.post(LOGIN_URI, new LoginResultReader(), new NameValuePair[]{new BasicNameValuePair("email", this.email), new BasicNameValuePair("password", this.password)});
        this.log.debug("Login result: {}", (Object)loginResult);
    }

    @Deprecated
    public Depth getDepth() throws IOException {
        URI depthUri;
        try {
            depthUri = new URIBuilder(DEPTH_URI).setParameter("a", "marketdepth").setParameter("random", String.valueOf(Math.random())).build();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        return this.httpClient.get(depthUri, Depth.class);
    }

    public Funds getFunds() throws IOException {
        LoginResult loginResult = this.httpClient.get(HTTPS_BASE, new LoginResultReader());
        return loginResult.getFunds();
    }

    public MyTradeInfo getMyTradeInfo() throws IOException {
        URI uri;
        try {
            uri = new URIBuilder(ACCOUNT_AJAX_URI).setParameter("m", "my_trade_info").setParameter("r", String.valueOf(Math.random())).build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return this.httpClient.get(uri, MyTradeInfo.class);
    }

    public BigDecimal getMinAmountPerOrder() {
        return new BigDecimal("0.001");
    }

    public void buy(BigDecimal price, BigDecimal amount) throws IOException {
        this.trade(Type.BUY, price, amount);
    }

    public void sell(BigDecimal price, BigDecimal amount) throws IOException {
        this.trade(Type.SELL, price, amount);
    }

    @Deprecated
    public List<Delegation> cancel(long id) throws IOException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(2);
        params.add((NameValuePair)new BasicNameValuePair("a", "cancel"));
        params.add((NameValuePair)new BasicNameValuePair("id", String.valueOf(id)));
        this.trade(TRADE_URI, CANCEL_REFERER_URI, params);
        return this.getDelegations();
    }

    public List<Delegation> getDelegations() throws IOException {
        URI uri;
        try {
            uri = new URIBuilder(TRADE_URI).setParameter("a", "delegation").build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return this.httpClient.get(uri, new DelegationReader());
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    private void trade(Type type, BigDecimal price, BigDecimal amount) throws IOException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(3);
        params.add((NameValuePair)new BasicNameValuePair("a", type.toString()));
        params.add((NameValuePair)new BasicNameValuePair("trading", "guding"));
        params.add((NameValuePair)new BasicNameValuePair("price", price.toPlainString()));
        params.add((NameValuePair)new BasicNameValuePair("amount", amount.toPlainString()));
        this.trade(TRADE_URI, TRADE_URI, params);
    }

    private void trade(URI tradeUri, URI referer, List<NameValuePair> params) throws IOException {
        TradeResult tradeResult = this.executeXmlRequest(tradeUri, referer, params, TradeResult.class);
        if (tradeResult.getCode() != 0) {
            throw new HuobiClientException(tradeResult.getMsg());
        }
    }

    private <T> T executeXmlRequest(URI uri, URI referer, List<NameValuePair> params, Class<T> objectClass) throws IOException {
        HttpPost post = new HttpPost(uri);
        post.setHeader("X-Requested-With", "XMLHttpRequest");
        this.log.debug("Setting header Referer: {}", (Object)referer);
        post.setHeader("Referer", referer.toString());
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        JsonValueReader<T> valueReader = new JsonValueReader<T>(new ObjectMapper(), objectClass);
        return this.httpClient.execute(valueReader, (HttpUriRequest)post);
    }

    private void initLoginPage() throws IOException {
        this.httpClient.get(HTTPS_BASE, VoidValueReader.getInstance());
    }
}

