/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.huobi.rest.service.polling;

import com.xeiam.xchange.Exchange;
import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.dto.trade.MarketOrder;
import com.xeiam.xchange.dto.trade.OpenOrders;
import com.xeiam.xchange.dto.trade.UserTrades;
import com.xeiam.xchange.exceptions.ExchangeException;
import com.xeiam.xchange.exceptions.NotAvailableFromExchangeException;
import com.xeiam.xchange.exceptions.NotYetImplementedForExchangeException;
import com.xeiam.xchange.service.polling.trade.PollingTradeService;
import com.xeiam.xchange.service.polling.trade.params.TradeHistoryParams;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.oxerr.huobi.rest.HuobiAdapters;
import org.oxerr.huobi.rest.dto.trade.CancelOrderResult;
import org.oxerr.huobi.rest.dto.trade.Order;
import org.oxerr.huobi.rest.dto.trade.PlaceOrderResult;
import org.oxerr.huobi.rest.service.polling.HuobiTradeServiceRaw;

public class HuobiTradeService
extends HuobiTradeServiceRaw
implements PollingTradeService {
    private final Map<CurrencyPair, Integer> coinTypes = new HashMap<CurrencyPair, Integer>(2);

    public HuobiTradeService(Exchange exchange) {
        super(exchange);
        this.coinTypes.put(CurrencyPair.BTC_CNY, 1);
        this.coinTypes.put(CurrencyPair.LTC_CNY, 2);
    }

    public OpenOrders getOpenOrders() throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        ArrayList<LimitOrder> openOrders = new ArrayList<LimitOrder>();
        for (CurrencyPair currencyPair : this.getExchangeSymbols()) {
            Order[] orders = this.getHUOBIOrders(this.coinTypes.get(currencyPair));
            openOrders.addAll(HuobiAdapters.adaptOpenOrders(orders, currencyPair));
        }
        return new OpenOrders(openOrders);
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        PlaceOrderResult result = this.placeHUOBIMarketOrder(marketOrder.getType(), this.coinTypes.get(marketOrder.getCurrencyPair()), marketOrder.getTradableAmount());
        return HuobiAdapters.adaptPlaceOrderResult(result);
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        PlaceOrderResult result = this.placeHUOBILimitOrder(limitOrder.getType(), this.coinTypes.get(limitOrder.getCurrencyPair()), limitOrder.getLimitPrice(), limitOrder.getTradableAmount());
        return HuobiAdapters.adaptPlaceOrderResult(result);
    }

    public boolean cancelOrder(String orderId) throws IOException {
        CurrencyPair currencyPair;
        long id = Long.parseLong(orderId);
        CancelOrderResult result = null;
        Iterator<CurrencyPair> iterator = this.getExchangeSymbols().iterator();
        while (iterator.hasNext() && (result = this.cancelHUOBIOrder(this.coinTypes.get(currencyPair = iterator.next()), id)).getCode() != 0 && result.getCode() == 26) {
        }
        return result != null && "success".equals(result.getResult());
    }

    public UserTrades getTradeHistory(Object ... arguments) {
        throw new NotAvailableFromExchangeException();
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        throw new NotYetImplementedForExchangeException();
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return null;
    }
}

