/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.huobi.rest.service.polling;

import com.xeiam.xchange.Exchange;
import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.dto.Order;
import java.io.IOException;
import java.math.BigDecimal;
import org.oxerr.huobi.rest.dto.trade.CancelOrderResult;
import org.oxerr.huobi.rest.dto.trade.Order;
import org.oxerr.huobi.rest.dto.trade.PlaceOrderResult;
import org.oxerr.huobi.rest.service.polling.HuobiBaseTradeService;

public class HuobiTradeServiceRaw
extends HuobiBaseTradeService {
    private final String tradePassword;

    protected HuobiTradeServiceRaw(Exchange exchange) {
        super(exchange);
        ExchangeSpecification spec = exchange.getExchangeSpecification();
        this.tradePassword = (String)spec.getExchangeSpecificParametersItem("trade_password");
    }

    public Order[] getHUOBIOrders(int coinType) throws IOException {
        return this.huobi.getOrders("get_orders", this.accessKey, coinType, this.nextCreated(), this.digest);
    }

    public Order getHUOBIOrder(int coinType, long id) throws IOException {
        return this.huobi.getOrder("order_info", this.accessKey, coinType, id, this.nextCreated(), this.digest);
    }

    public PlaceOrderResult placeHUOBILimitOrder(Order.OrderType type, int coinType, BigDecimal price, BigDecimal amount) throws IOException {
        String method = type == Order.OrderType.BID ? "buy" : "sell";
        PlaceOrderResult result = this.tradePassword == null ? this.huobi.placeLimitOrder(method, this.accessKey, coinType, price.toPlainString(), amount.toPlainString(), this.nextCreated(), this.digest) : this.huobi.placeLimitOrder(method, this.accessKey, coinType, price.toPlainString(), amount.toPlainString(), this.nextCreated(), this.digest, this.tradePassword);
        return result;
    }

    public PlaceOrderResult placeHUOBIMarketOrder(Order.OrderType type, int coinType, BigDecimal amount) throws IOException {
        String method = type == Order.OrderType.BID ? "buy_market" : "sell_market";
        PlaceOrderResult result = this.tradePassword == null ? this.huobi.placeMarketOrder(method, this.accessKey, coinType, amount.toPlainString(), this.nextCreated(), this.digest) : this.huobi.placeMarketOrder(method, this.accessKey, coinType, amount.toPlainString(), this.nextCreated(), this.digest, this.tradePassword);
        return result;
    }

    public CancelOrderResult cancelHUOBIOrder(int coinType, long id) throws IOException {
        return this.huobi.cancelOrder("cancel_order", this.accessKey, coinType, id, this.nextCreated(), this.digest);
    }

    public PlaceOrderResult modifyHUOBIOrder(int coinType, long id, BigDecimal price, BigDecimal amount) throws IOException {
        return this.huobi.modifyOrder("modify_order", this.accessKey, coinType, id, price.toPlainString(), amount.toPlainString(), this.nextCreated(), this.digest);
    }
}

