/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.huobi.rest.valuereader;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.oxerr.huobi.rest.HuobiClientException;
import org.oxerr.huobi.rest.domain.Delegation;
import org.oxerr.huobi.rest.domain.Type;
import org.oxerr.huobi.rest.valuereader.HTMLReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLDivElement;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableRowElement;
import org.w3c.dom.html.HTMLTableSectionElement;

public class DelegationReader
extends HTMLReader<List<Delegation>> {
    private final Logger log = LoggerFactory.getLogger(DelegationReader.class);
    private DateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm");

    @Override
    protected List<Delegation> parse(HTMLDocument document) throws HuobiClientException {
        ArrayList<Delegation> delegations = new ArrayList<Delegation>();
        HTMLDivElement myDelegationLegend = this.findMyDelegationLegend(document);
        Node next = myDelegationLegend.getNextSibling();
        if (next != null) {
            next = next.getNextSibling();
        }
        if (next != null) {
            this.parse(next, delegations);
        } else {
            this.log.debug("No delegations.");
        }
        return delegations;
    }

    private List<Delegation> parse(Node next, List<Delegation> delegations) throws HuobiClientException {
        ArrayList<HTMLTableElement> tables = new ArrayList<HTMLTableElement>();
        this.findTables(next, tables);
        int count = tables.size();
        this.log.debug("tables.size: {}", (Object)count);
        if (count > 0) {
            HTMLTableElement table = (HTMLTableElement)tables.get(0);
            try {
                this.parse(table, delegations);
            }
            catch (ParseException | DOMException e) {
                throw new HuobiClientException(e);
            }
        }
        return delegations;
    }

    private HTMLDivElement findMyDelegationLegend(HTMLDocument document) {
        NodeList divNodeList = document.getElementsByTagName("div");
        HTMLDivElement myDelegationLegend = null;
        for (int i = 0; i < divNodeList.getLength(); ++i) {
            HTMLDivElement div = (HTMLDivElement)divNodeList.item(i);
            String className = div.getClassName();
            String textContent = StringUtils.trim((String)div.getTextContent());
            if (!StringUtils.equals((CharSequence)className, (CharSequence)"legend") || !StringUtils.equals((CharSequence)textContent, (CharSequence)"\u6211\u7684\u59d4\u6258")) continue;
            myDelegationLegend = div;
            break;
        }
        return myDelegationLegend;
    }

    private void findTables(Node node, List<HTMLTableElement> tables) {
        this.log.debug("node type: {}", node.getClass());
        if (node instanceof HTMLTableElement) {
            tables.add((HTMLTableElement)node);
        } else if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                this.findTables(children.item(i), tables);
            }
        }
    }

    private void parse(HTMLTableElement table, List<Delegation> delegations) throws DOMException, ParseException {
        HTMLCollection tbodies = table.getTBodies();
        for (int i = 0; i < tbodies.getLength(); ++i) {
            Node node = tbodies.item(i);
            this.log.debug("{}", node.getClass());
            HTMLTableSectionElement tableSectionElement = (HTMLTableSectionElement)node;
            HTMLCollection rows = tableSectionElement.getRows();
            for (int j = 0; j < rows.getLength(); ++j) {
                Delegation delegation = new Delegation();
                HTMLTableRowElement row = (HTMLTableRowElement)rows.item(j);
                HTMLCollection cells = row.getCells();
                HTMLTableCellElement operationCell = (HTMLTableCellElement)cells.item(0);
                delegation.setId(this.parseId(operationCell));
                delegation.setDate(this.dateFormat.parse(cells.item(1).getTextContent()));
                delegation.setType(Type.delegationToType(cells.item(2).getTextContent()));
                delegation.setPrice(new BigDecimal(cells.item(3).getTextContent()));
                delegation.setAmount(new BigDecimal(cells.item(4).getTextContent()));
                delegation.setTrading(new BigDecimal(cells.item(5).getTextContent()));
                delegations.add(delegation);
            }
        }
    }

    private long parseId(HTMLTableCellElement cell) {
        String id = cell.getFirstChild().getAttributes().getNamedItem("value").getTextContent();
        return Integer.parseInt(id);
    }
}

