/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.huobi.rest.valuereader;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;
import org.cyberneko.html.parsers.DOMParser;
import org.oxerr.huobi.rest.HuobiClientException;
import org.oxerr.huobi.rest.valuereader.ValueReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.html.HTMLDocument;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class HTMLReader<T>
implements ValueReader<T> {
    private final Logger log = LoggerFactory.getLogger(HTMLReader.class);

    @Override
    public T read(InputStream inputStream) throws IOException {
        String content = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
        this.log.debug("Parsing HTML: {}", (Object)content);
        try {
            return this.parse(content);
        }
        catch (HuobiClientException e) {
            throw e;
        }
        catch (IOException e) {
            this.log.error("Parse from \"{}\" failed.", (Object)content);
            throw e;
        }
        catch (SAXException e) {
            String msg = String.format("Parse from \"%1$s\" failed.", content);
            throw new IOException(msg, e);
        }
    }

    protected abstract T parse(HTMLDocument var1) throws HuobiClientException;

    private T parse(String content) throws UnsupportedEncodingException, IOException, SAXException {
        HTMLDocument document = this.toDocument(content);
        return this.parse(document);
    }

    private HTMLDocument toDocument(String content) throws UnsupportedEncodingException, IOException, SAXException {
        InputSource inputSource = new InputSource(new InputStreamReader(IOUtils.toInputStream((String)content, (String)"UTF-8"), "UTF-8"));
        DOMParser parser = new DOMParser();
        parser.parse(inputSource);
        HTMLDocument document = (HTMLDocument)parser.getDocument();
        return document;
    }
}

