/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.huobi.rest.valuereader;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.oxerr.huobi.rest.valuereader.ValueReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonValueReader<T>
implements ValueReader<T> {
    private final Logger log = LoggerFactory.getLogger(JsonValueReader.class);
    private final ObjectMapper objectMapper;
    private final Class<T> valueType;

    public JsonValueReader(ObjectMapper objectMapper, Class<T> valueType) {
        this.objectMapper = objectMapper;
        this.valueType = valueType;
    }

    @Override
    public T read(InputStream inputStream) throws IOException {
        String content = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
        return this.read(content);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T read(String content) throws IOException {
        this.log.debug("Reading {} from \"{}\".", this.valueType, (Object)content);
        try (InputStream in = IOUtils.toInputStream((String)content, (String)"UTF-8");){
            Object object = this.objectMapper.readValue(in, this.valueType);
            return (T)object;
        }
        catch (JsonParseException e) {
            String msg = String.format("Parse from \"%1$s\" failed: %2$s", content, e.getMessage());
            throw new JsonParseException(msg, e.getLocation(), (Throwable)e);
        }
    }
}

