/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.huobi.rest.valuereader;

import java.math.BigDecimal;
import org.oxerr.huobi.rest.LoginRequiredException;
import org.oxerr.huobi.rest.domain.Funds;
import org.oxerr.huobi.rest.domain.LoginResult;
import org.oxerr.huobi.rest.valuereader.HTMLReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLFormElement;

public class LoginResultReader
extends HTMLReader<LoginResult> {
    private final Logger log = LoggerFactory.getLogger(LoginResult.class);

    @Override
    protected LoginResult parse(HTMLDocument document) throws LoginRequiredException {
        Element loginForm = document.getElementById("login");
        if (loginForm instanceof HTMLFormElement) {
            throw new LoginRequiredException();
        }
        LoginResult loginResult = new LoginResult();
        Funds funds = new Funds();
        loginResult.setFunds(funds);
        boolean total = false;
        boolean netAsset = false;
        boolean availableCny = false;
        boolean frozenCny = false;
        boolean availableBtc = false;
        boolean frozenBtc = false;
        boolean availableLtc = false;
        boolean frozenLtc = false;
        boolean loanCny = false;
        boolean loanBtc = false;
        boolean loanLtc = false;
        NodeList spanNodeList = document.getElementsByTagName("span");
        for (int i = 0; i < spanNodeList.getLength(); ++i) {
            HTMLElement element = (HTMLElement)spanNodeList.item(i);
            String className = element.getClassName();
            String textContent = element.getTextContent();
            this.log.debug("className: {}, textContent: {}.", (Object)className, (Object)textContent);
            switch (className) {
                case "user-info-level pull-left": {
                    loginResult.setLevel(textContent.trim());
                }
            }
        }
        NodeList bNodeList = document.getElementsByTagName("b");
        block33: for (int i = 0; i < bNodeList.getLength(); ++i) {
            HTMLElement element = (HTMLElement)bNodeList.item(i);
            String className = element.getClassName();
            String textContent = element.getTextContent();
            this.log.debug("className: {}, textContent: {}.", (Object)className, (Object)textContent);
            switch (className) {
                case "user_total": {
                    if (total) continue block33;
                    funds.setTotal(new BigDecimal(textContent));
                    total = true;
                    continue block33;
                }
                case "user_net_asset": {
                    if (netAsset) continue block33;
                    funds.setNetAsset(new BigDecimal(textContent));
                    netAsset = true;
                    continue block33;
                }
                case "user_available_cny": {
                    if (availableCny) continue block33;
                    funds.setAvailableCny(new BigDecimal(textContent));
                    availableCny = true;
                    continue block33;
                }
                case "user_frozen_cny": {
                    if (frozenCny) continue block33;
                    funds.setFrozenCny(new BigDecimal(textContent));
                    frozenCny = true;
                    continue block33;
                }
                case "user_available_btc": {
                    if (availableBtc) continue block33;
                    funds.setAvailableBtc(new BigDecimal(textContent));
                    availableBtc = true;
                    continue block33;
                }
                case "user_frozen_btc": {
                    if (frozenBtc) continue block33;
                    funds.setFrozenBtc(new BigDecimal(textContent));
                    frozenBtc = true;
                    continue block33;
                }
                case "user_available_ltc": {
                    if (availableLtc) continue block33;
                    funds.setAvailableLtc(new BigDecimal(textContent));
                    availableLtc = true;
                    continue block33;
                }
                case "user_frozen_ltc": {
                    if (frozenLtc) continue block33;
                    funds.setFrozenLtc(new BigDecimal(textContent));
                    frozenLtc = true;
                    continue block33;
                }
                case "user_loan_cny": {
                    if (loanCny) continue block33;
                    funds.setLoanCny(new BigDecimal(textContent));
                    loanCny = true;
                    continue block33;
                }
                case "user_loan_btc": {
                    if (loanBtc) continue block33;
                    funds.setLoanBtc(new BigDecimal(textContent));
                    loanBtc = true;
                    continue block33;
                }
                case "user_loan_ltc": {
                    if (loanLtc) continue block33;
                    funds.setLoanLtc(new BigDecimal(textContent));
                    loanLtc = true;
                    continue block33;
                }
            }
        }
        return loginResult;
    }
}

