/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.ipyy.client.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.message.BasicNameValuePair;
import org.oxerr.ipyy.client.core.ReturnSMSUnmarshaller;
import org.oxerr.ipyy.client.dto.ReturnSMS;

public class IPYYClient {
    private final String url;
    private final String account;
    private final String password;
    private Integer socketTimeout;
    private Integer connectTimeout;
    private HttpHost proxy;
    private final ReturnSMSUnmarshaller returnSMSUnmarshaller;

    public IPYYClient(String url, ReturnSMSUnmarshaller returnSMSUnmarshaller, String account, String password) {
        this.url = url;
        this.returnSMSUnmarshaller = returnSMSUnmarshaller;
        this.account = account;
        this.password = password;
    }

    public void setSocketTimeout(Integer socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setProxy(HttpHost proxy) {
        this.proxy = proxy;
    }

    public ReturnSMS send(String mobile, String content) throws IOException {
        return this.send(new String[]{mobile}, content);
    }

    public ReturnSMS send(String[] mobiles, String content) throws IOException {
        List<NameValuePair> nvps = Arrays.asList(new BasicNameValuePair("action", "send"), new BasicNameValuePair("userid", ""), new BasicNameValuePair("account", this.account), new BasicNameValuePair("password", this.password), new BasicNameValuePair("mobile", String.join((CharSequence)",", mobiles)), new BasicNameValuePair("content", content), new BasicNameValuePair("sendTime", ""), new BasicNameValuePair("extno", ""));
        Request request = Request.Post((String)this.url);
        if (this.socketTimeout != null) {
            request.socketTimeout(this.socketTimeout.intValue());
        }
        if (this.connectTimeout != null) {
            request.connectTimeout(this.connectTimeout.intValue());
        }
        if (this.proxy != null) {
            request.viaProxy(this.proxy);
        }
        Response response = request.bodyForm(nvps, Consts.UTF_8).execute();
        try (InputStream is = response.returnContent().asStream();){
            ReturnSMS returnSMS = this.returnSMSUnmarshaller.unmarshal(is);
            return returnSMS;
        }
    }
}

