/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.vividseats.client.cached.redisson.inventory;

import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.oxerr.ticket.inventory.support.Event;
import org.oxerr.ticket.inventory.support.Listing;
import org.oxerr.ticket.inventory.support.cached.redisson.CachedListing;
import org.oxerr.ticket.inventory.support.cached.redisson.ListingConfiguration;
import org.oxerr.ticket.inventory.support.cached.redisson.RedissonCachedListingServiceSupport;
import org.oxerr.ticket.inventory.support.cached.redisson.Status;
import org.oxerr.vividseats.client.cached.inventory.VividSeatsCachedListingService;
import org.oxerr.vividseats.client.cached.inventory.VividSeatsEvent;
import org.oxerr.vividseats.client.cached.inventory.VividSeatsListing;
import org.oxerr.vividseats.client.cached.redisson.inventory.VividSeatsCachedEvent;
import org.oxerr.vividseats.client.cached.redisson.inventory.VividSeatsCachedListing;
import org.oxerr.vividseats.client.inventory.ListingService;
import org.oxerr.vividseats.client.model.inventory.BrokerListing;
import org.redisson.api.RedissonClient;

public class RedissonCachedListingService
extends RedissonCachedListingServiceSupport<String, String, BrokerListing, VividSeatsListing, VividSeatsEvent, VividSeatsCachedListing>
implements VividSeatsCachedListingService {
    private final ListingService listingService;

    public RedissonCachedListingService(ListingService listingService, RedissonClient redissonClient, String keyPrefix, Executor executor) {
        this(listingService, redissonClient, keyPrefix, executor, new ListingConfiguration());
    }

    public RedissonCachedListingService(ListingService listingService, RedissonClient redissonClient, String keyPrefix, Executor executor, ListingConfiguration listingConfiguration) {
        super(redissonClient, keyPrefix, executor, listingConfiguration);
        this.listingService = listingService;
    }

    protected boolean shouldCreate(@Nonnull VividSeatsEvent event, @Nonnull VividSeatsListing listing, @Nullable VividSeatsCachedListing cachedListing) {
        boolean shouldCreate = super.shouldCreate((Event)event, (Listing)listing, (CachedListing)cachedListing);
        return shouldCreate || cachedListing != null && !Objects.equals(listing.getVividSeatsEventId(), cachedListing.getVividSeatsEventId());
    }

    protected boolean shouldUpdate(@Nonnull VividSeatsEvent event, @Nonnull VividSeatsListing listing, @Nullable VividSeatsCachedListing cachedListing) {
        boolean shouldUpdate = super.shouldUpdate((Event)event, (Listing)listing, (CachedListing)cachedListing);
        return shouldUpdate || cachedListing != null && !Objects.equals(listing.getVividSeatsEventId(), cachedListing.getVividSeatsEventId());
    }

    protected int getPriority(@Nonnull VividSeatsEvent event, @Nullable VividSeatsListing listing, @Nullable VividSeatsCachedListing cachedListing) {
        if (listing == null || cachedListing == null) {
            return 0;
        }
        int priority = 0;
        BrokerListing r = (BrokerListing)listing.getRequest();
        BrokerListing cr = (BrokerListing)cachedListing.getRequest();
        priority += Objects.equals(r.getQuantity(), cr.getQuantity()) ? 0 : 1;
        priority += Objects.equals(r.getSection(), cr.getSection()) ? 0 : 1;
        priority += Objects.equals(r.getRow(), cr.getRow()) ? 0 : 1;
        priority += Objects.equals(r.getSeatFrom(), cr.getSeatFrom()) ? 0 : 1;
        priority += Objects.equals(r.getSeatThru(), cr.getSeatThru()) ? 0 : 1;
        return priority += Objects.equals(r.getNotes(), cr.getNotes()) ? 0 : 1;
    }

    protected boolean shouldDelete(@Nonnull VividSeatsEvent event, @Nonnull Set<String> inventoryListingIds, @Nonnull String listingId, @Nonnull VividSeatsCachedListing cachedListing) {
        return super.shouldDelete((Event)event, inventoryListingIds, (Serializable)((Object)listingId), (CachedListing)cachedListing) || !Objects.equals(event.getVividSeatsEventId(), cachedListing.getVividSeatsEventId());
    }

    protected void createListing(VividSeatsEvent event, VividSeatsListing listing) throws IOException {
        this.listingService.create((BrokerListing)listing.getRequest());
    }

    protected void deleteListing(VividSeatsEvent event, String listingId) throws IOException {
        this.listingService.deleteListing(listingId);
    }

    protected VividSeatsCachedListing toCached(VividSeatsEvent event, VividSeatsListing listing, Status status) {
        return new VividSeatsCachedListing(new VividSeatsCachedEvent(event), listing, status);
    }
}

