/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.vividseats.client.cached.redisson.inventory;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.oxerr.ticket.inventory.support.Event;
import org.oxerr.ticket.inventory.support.Listing;
import org.oxerr.ticket.inventory.support.cached.redisson.CachedListing;
import org.oxerr.ticket.inventory.support.cached.redisson.ListingConfiguration;
import org.oxerr.ticket.inventory.support.cached.redisson.RedissonCachedListingServiceSupport;
import org.oxerr.ticket.inventory.support.cached.redisson.Status;
import org.oxerr.vividseats.client.cached.inventory.CheckOptions;
import org.oxerr.vividseats.client.cached.inventory.VividSeatsCachedListingService;
import org.oxerr.vividseats.client.cached.inventory.VividSeatsEvent;
import org.oxerr.vividseats.client.cached.inventory.VividSeatsListing;
import org.oxerr.vividseats.client.cached.redisson.inventory.Listings;
import org.oxerr.vividseats.client.cached.redisson.inventory.VividSeatsCachedEvent;
import org.oxerr.vividseats.client.cached.redisson.inventory.VividSeatsCachedListing;
import org.oxerr.vividseats.client.inventory.BrokerListingQuery;
import org.oxerr.vividseats.client.inventory.ListingService;
import org.oxerr.vividseats.client.model.inventory.BrokerListing;
import org.redisson.api.RedissonClient;

public class RedissonCachedListingService
extends RedissonCachedListingServiceSupport<String, String, BrokerListing, VividSeatsListing, VividSeatsEvent, VividSeatsCachedListing>
implements VividSeatsCachedListingService {
    private final Logger log = LogManager.getLogger();
    private final ListingService listingService;

    public RedissonCachedListingService(ListingService listingService, RedissonClient redissonClient, String keyPrefix, Executor executor) {
        this(listingService, redissonClient, keyPrefix, executor, new ListingConfiguration());
    }

    public RedissonCachedListingService(ListingService listingService, RedissonClient redissonClient, String keyPrefix, Executor executor, ListingConfiguration listingConfiguration) {
        super(redissonClient, keyPrefix, executor, listingConfiguration);
        this.listingService = listingService;
    }

    protected boolean shouldCreate(@Nonnull VividSeatsEvent event, @Nonnull VividSeatsListing listing, @Nullable VividSeatsCachedListing cachedListing) {
        boolean shouldCreate = super.shouldCreate((Event)event, (Listing)listing, (CachedListing)cachedListing);
        return shouldCreate || cachedListing != null && !Objects.equals(listing.getMarketplaceEventId(), cachedListing.getEvent().getMarketplaceEventId());
    }

    protected boolean shouldUpdate(@Nonnull VividSeatsEvent event, @Nonnull VividSeatsListing listing, @Nullable VividSeatsCachedListing cachedListing) {
        boolean shouldUpdate = super.shouldUpdate((Event)event, (Listing)listing, (CachedListing)cachedListing);
        return shouldUpdate || cachedListing != null && !Objects.equals(listing.getMarketplaceEventId(), cachedListing.getEvent().getMarketplaceEventId());
    }

    protected int getPriority(@Nonnull VividSeatsEvent event, @Nullable VividSeatsListing listing, @Nullable VividSeatsCachedListing cachedListing) {
        if (listing == null || cachedListing == null) {
            return 0;
        }
        int priority = 0;
        BrokerListing r = (BrokerListing)listing.getRequest();
        BrokerListing cr = (BrokerListing)cachedListing.getRequest();
        priority += Objects.equals(r.getQuantity(), cr.getQuantity()) ? 0 : 1;
        priority += Objects.equals(r.getSection(), cr.getSection()) ? 0 : 1;
        priority += Objects.equals(r.getRow(), cr.getRow()) ? 0 : 1;
        priority += Objects.equals(r.getSeatFrom(), cr.getSeatFrom()) ? 0 : 1;
        priority += Objects.equals(r.getSeatThru(), cr.getSeatThru()) ? 0 : 1;
        return priority += Objects.equals(r.getNotes(), cr.getNotes()) ? 0 : 1;
    }

    protected boolean shouldDelete(@Nonnull VividSeatsEvent event, @Nonnull Set<String> inventoryListingIds, @Nonnull String listingId, @Nonnull VividSeatsCachedListing cachedListing) {
        return super.shouldDelete((Event)event, inventoryListingIds, (Serializable)((Object)listingId), (CachedListing)cachedListing) || !Objects.equals(event.getMarketplaceEventId(), cachedListing.getEvent().getMarketplaceEventId());
    }

    protected void createListing(VividSeatsEvent event, VividSeatsListing listing) throws IOException {
        this.listingService.create((BrokerListing)listing.getRequest());
    }

    protected void deleteListing(VividSeatsEvent event, String listingId) throws IOException {
        this.listingService.deleteListing(listingId);
    }

    protected void deleteListing(VividSeatsEvent event, String listingId, VividSeatsCachedListing cachedListing, int priority) throws IOException {
        this.listingService.deleteListing(listingId);
    }

    protected VividSeatsCachedListing toCached(VividSeatsEvent event, VividSeatsListing listing, Status status) {
        return new VividSeatsCachedListing(new VividSeatsCachedEvent(event), listing, status);
    }

    public void check() throws UncheckedIOException {
        this.check(CheckOptions.defaults());
    }

    public void check(CheckOptions options) throws UncheckedIOException {
        List listings;
        List tasks = Collections.synchronizedList(new ArrayList());
        Map<String, String> ticketIdToCacheName = this.getCacheNamesStream(options.chunkSize()).flatMap(cacheName -> this.getCache((String)cacheName).keySet().stream().map(id -> Map.entry(id, cacheName))).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        try {
            listings = this.listingService.get(new BrokerListingQuery());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = listings::size;
        this.log.debug("[check] listings size: {}", supplierArray);
        List deleteTasks = listings.stream().filter(listing -> !ticketIdToCacheName.containsKey(listing.getTicketId())).map(listing -> this.callAsync(() -> {
            this.listingService.deleteListing(listing.getTicketId());
            return null;
        })).collect(Collectors.toUnmodifiableList());
        tasks.addAll(deleteTasks);
        listings.stream().filter(listing -> ticketIdToCacheName.containsKey(listing.getTicketId())).forEach(listing -> {
            String cacheName = (String)ticketIdToCacheName.get(listing.getTicketId());
            VividSeatsCachedListing cachedListing = (VividSeatsCachedListing)((Object)((Object)this.getCache(cacheName).get((Object)listing.getTicketId())));
            if (cachedListing == null) {
                CompletableFuture task = this.callAsync(() -> {
                    this.listingService.deleteListing(listing.getTicketId());
                    return null;
                });
                tasks.add(task);
            } else if (!this.isSame((BrokerListing)listing, (BrokerListing)cachedListing.getRequest())) {
                CompletableFuture task = this.callAsync(() -> {
                    VividSeatsEvent e = cachedListing.getEvent().toVividSeatsEvent();
                    VividSeatsListing l = cachedListing.toVividSeatsListing();
                    int p = this.getPriority(e, l, cachedListing);
                    this.updateListing((Event)e, (Listing)l, (Listing)((VividSeatsListing)null), p);
                    return null;
                });
                tasks.add(task);
            }
        });
        Set existingTicketIds = listings.stream().map(BrokerListing::getTicketId).collect(Collectors.toSet());
        List createTasks = ticketIdToCacheName.entrySet().stream().filter(entry -> !existingTicketIds.contains(entry.getKey())).map(entry -> this.callAsync(() -> {
            String cacheName = (String)entry.getValue();
            VividSeatsCachedListing cachedListing = (VividSeatsCachedListing)((Object)((Object)((Object)this.getCache(cacheName).get(entry.getKey()))));
            if (cachedListing != null) {
                VividSeatsEvent e = cachedListing.getEvent().toVividSeatsEvent();
                VividSeatsListing l = cachedListing.toVividSeatsListing();
                this.createListing(e, l);
            }
            return null;
        })).collect(Collectors.toUnmodifiableList());
        tasks.addAll(createTasks);
        Supplier[] supplierArray2 = new Supplier[1];
        supplierArray2[0] = tasks::size;
        this.log.debug("[check] checking size: {}", supplierArray2);
        CompletableFuture.allOf((CompletableFuture[])tasks.toArray(CompletableFuture[]::new)).join();
    }

    private boolean isSame(BrokerListing listing, BrokerListing request) {
        boolean equals = Listings.isSame(listing, request);
        this.log.debug("[isSame] listing: {}, request: {}, equals: {}", new Supplier[]{() -> Listings.toString(listing), () -> Listings.toString(request), () -> equals});
        return equals;
    }
}

