/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.vividseats.client.cxf.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import io.github.poshjosh.ratelimiter.store.BandwidthsStore;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.oxerr.vividseats.client.VividSeatsClient;
import org.oxerr.vividseats.client.cxf.impl.ApiTokenHeaderFilter;
import org.oxerr.vividseats.client.cxf.impl.InvokedMethodHolder;
import org.oxerr.vividseats.client.cxf.impl.RateLimiterFilter;
import org.oxerr.vividseats.client.cxf.impl.inventory.ListingServiceImpl;
import org.oxerr.vividseats.client.cxf.resource.inventory.ListingResource;

public class CXFVividSeatsClient
implements VividSeatsClient {
    private static final String DEFAULT_BASE_URL = "https://brokers.vividseats.com/webservices";
    private final ListingServiceImpl listingService;
    private final HTTPClientPolicy policy;

    public CXFVividSeatsClient(String token, BandwidthsStore<String> bandwidthsStore) {
        this(token, bandwidthsStore, new HTTPClientPolicy());
    }

    public CXFVividSeatsClient(String token, BandwidthsStore<String> bandwidthsStore, HTTPClientPolicy policy) {
        this.policy = policy;
        JacksonJsonProvider jacksonJsonProvider = this.createJacksonJsonProvider();
        RateLimiterFilter rateLimiterFilter = new RateLimiterFilter(bandwidthsStore);
        ApiTokenHeaderFilter tokenFilter = new ApiTokenHeaderFilter(token);
        org.oxerr.vividseats.client.cxf.resource.v1.inventory.ListingResource listingResourceV1 = this.createProxy(DEFAULT_BASE_URL, org.oxerr.vividseats.client.cxf.resource.v1.inventory.ListingResource.class, List.of(jacksonJsonProvider, rateLimiterFilter));
        List<ApiTokenHeaderFilter> providers = List.of(jacksonJsonProvider, rateLimiterFilter, tokenFilter);
        ListingResource listingResource = this.createProxy(DEFAULT_BASE_URL, ListingResource.class, providers);
        this.listingService = new ListingServiceImpl(listingResourceV1, listingResource, token);
    }

    public ListingServiceImpl getListingService() {
        return this.listingService;
    }

    protected <T> T createProxy(String baseAddress, Class<T> cls, List<?> providers) {
        Object client = JAXRSClientFactory.create((String)baseAddress, cls, providers);
        this.configureClient(client, this.policy);
        return (T)this.createMethodTrackingProxy(cls, client);
    }

    private <T> T createMethodTrackingProxy(Class<T> cls, T delegate) {
        InvocationHandler handler = (proxy, method, args) -> {
            InvokedMethodHolder.set(method);
            return method.invoke(delegate, args);
        };
        return (T)Proxy.newProxyInstance(cls.getClassLoader(), new Class[]{cls}, handler);
    }

    protected <T> void configureClient(T client, HTTPClientPolicy policy) {
        ClientConfiguration config = WebClient.getConfig(client);
        HTTPConduit conduit = (HTTPConduit)config.getConduit();
        conduit.setClient(policy);
    }

    protected JacksonJsonProvider createJacksonJsonProvider() {
        JacksonJsonProvider provider = new JacksonJsonProvider();
        provider.setMapper(this.createObjectMapper());
        return provider;
    }

    protected ObjectMapper createObjectMapper() {
        return new ObjectMapper().registerModule((Module)new JavaTimeModule()).setSerializationInclusion(JsonInclude.Include.NON_ABSENT).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS, false).configure(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

