/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.vividseats.client.cxf.impl.inventory;

import jakarta.annotation.Nullable;
import java.util.List;
import org.oxerr.vividseats.client.cxf.model.v1.inventory.BrokerListings;
import org.oxerr.vividseats.client.cxf.resource.inventory.ListingResource;
import org.oxerr.vividseats.client.inventory.BrokerListingQuery;
import org.oxerr.vividseats.client.inventory.ListingService;
import org.oxerr.vividseats.client.model.inventory.BrokerListing;
import org.oxerr.vividseats.client.model.v1.inventory.Update;

public class ListingServiceImpl
implements ListingService {
    private final org.oxerr.vividseats.client.cxf.resource.v1.inventory.ListingResource listingResourceV1;
    private final ListingResource listingResource;
    private final String token;

    public ListingServiceImpl(org.oxerr.vividseats.client.cxf.resource.v1.inventory.ListingResource listingResourceV1, ListingResource listingResource, String token) {
        this.listingResourceV1 = listingResourceV1;
        this.listingResource = listingResource;
        this.token = token;
    }

    public BrokerListings getListings(@Nullable Integer ticketId) {
        return this.listingResourceV1.getListings(this.token, ticketId);
    }

    public List<BrokerListing> get(BrokerListingQuery q) {
        return this.listingResource.get(q.getListingId(), q.getInternalTicketId(), q.getProductionId(), q.getHeadlinerId(), q.getFromEventDate(), q.getToEventDate(), q.getIncludeFiles()).getListings();
    }

    public BrokerListing create(BrokerListing brokerListing) {
        return this.listingResource.create(brokerListing).getListing();
    }

    public void updateListing(Update update) {
        this.listingResourceV1.updateListing((CharSequence)this.token, update.getTicketId(), update.getQuantity(), update.getSection(), update.getRow(), update.getSeatFrom(), update.getSeatThru(), update.getNotes(), update.getPrice(), update.getElectronic(), update.getInHandDate(), update.getSplitType(), update.getSplitValue(), update.getBarcode(), update.getFaceValue(), update.getUnitTaxedCost());
    }

    public void update(BrokerListing brokerListing) {
        this.listingResource.update(brokerListing);
    }

    public void deleteListing(String ticketId) {
        this.listingResourceV1.deleteListing((CharSequence)this.token, ticketId);
    }

    public void delete(Long listingId, String internalTicketId) {
        this.listingResource.delete(listingId, internalTicketId);
    }
}

