/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.vividseats.client.cxf.impl.filter;

import io.github.poshjosh.ratelimiter.RateLimiter;
import io.github.poshjosh.ratelimiter.RateLimiterContext;
import io.github.poshjosh.ratelimiter.RateLimiterRegistries;
import io.github.poshjosh.ratelimiter.annotations.Rate;
import io.github.poshjosh.ratelimiter.store.BandwidthsStore;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.oxerr.vividseats.client.cxf.impl.support.InvocationHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimiterFilter
implements ClientRequestFilter {
    private final Logger log = LoggerFactory.getLogger(RateLimiterFilter.class);
    private final ConcurrentMap<Method, RateLimiter> limiters = new ConcurrentHashMap<Method, RateLimiter>();
    private final BandwidthsStore<?> bandwidthsStore;

    public RateLimiterFilter(BandwidthsStore<?> bandwidthsStore) {
        this.bandwidthsStore = bandwidthsStore;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        Method method = InvocationHolder.get().getMethod();
        this.acquire(method);
    }

    private void acquire(Method method) {
        this.log.trace("Invoked method: {}", (Object)method);
        Rate rate = method.getAnnotation(Rate.class);
        if (rate == null) {
            return;
        }
        RateLimiter limiter = this.limiters.computeIfAbsent(method, this::createRateLimiter);
        this.log.trace("Acquiring permit for {}...", (Object)method);
        double timeSpent = limiter.acquire();
        this.log.trace("Acquired permit for {} in {} seconds.", (Object)method, (Object)timeSpent);
    }

    private RateLimiter createRateLimiter(Method method) {
        RateLimiterContext context = RateLimiterContext.builder().classes(new Class[]{method.getDeclaringClass()}).store(this.bandwidthsStore).build();
        return RateLimiterRegistries.of((RateLimiterContext)context).getMethodRateLimiter(method);
    }
}

