/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.vividseats.client.cxf;

import io.github.poshjosh.ratelimiter.store.BandwidthsStore;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.oxerr.vividseats.client.cxf.InvokedMethodHolder;
import org.oxerr.vividseats.client.cxf.RateLimiterFilter;
import org.oxerr.vividseats.client.cxf.model.BrokerListings;
import org.oxerr.vividseats.client.cxf.resource.ListingResource;

public class CXFVividSeatsClient {
    private static final String DEFAULT_BASE_URL = "https://brokers.vividseats.com/webservices";
    private final String token;
    private final ListingResource listingResource;

    public CXFVividSeatsClient(String token, BandwidthsStore<String> bandwidthsStore) {
        this.token = token;
        this.listingResource = CXFVividSeatsClient.createProxy(DEFAULT_BASE_URL, ListingResource.class, Collections.singletonList(new RateLimiterFilter(bandwidthsStore)));
    }

    public BrokerListings getListings(Integer ticketId) {
        return this.listingResource.getListings(this.token, ticketId);
    }

    public static <T> T createProxy(String baseAddress, Class<T> cls, List<?> providers) {
        final Object client = JAXRSClientFactory.create((String)baseAddress, cls, providers);
        return (T)Proxy.newProxyInstance(cls.getClassLoader(), new Class[]{cls}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                InvokedMethodHolder.set(method);
                return method.invoke(client, args);
            }
        });
    }
}

